/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.clover;

import com.bmuschko.gradle.clover.HistoricalAdded;
import com.bmuschko.gradle.clover.HistoricalMover;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;

public class CloverReportHistoricalConvention {
    private boolean enabled = false;
    private String historyIncludes = "clover-*.xml.gz";
    private String packageFilter = null;
    private String from = null;
    private String to = null;
    private HistoricalAdded added = null;
    private final List<HistoricalMover> movers = new ArrayList<HistoricalMover>();
    private final ObjectFactory objectFactory;

    @Inject
    public CloverReportHistoricalConvention(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getJsonAdded() throws JsonProcessingException {
        if (this.added == null) {
            return null;
        }
        return this.added.toJson();
    }

    public Collection<String> getJsonMovers() throws JsonProcessingException {
        ArrayList<String> jsonMovers = new ArrayList<String>();
        for (HistoricalMover mover : this.movers) {
            jsonMovers.add(mover.toJson());
        }
        return jsonMovers;
    }

    public void added(Action<HistoricalAdded> action) {
        this.added = (HistoricalAdded)this.objectFactory.newInstance(HistoricalAdded.class, new Object[0]);
        action.execute((Object)this.added);
    }

    public void mover(Action<HistoricalMover> action) {
        HistoricalMover mover = (HistoricalMover)this.objectFactory.newInstance(HistoricalMover.class, new Object[0]);
        action.execute((Object)mover);
        this.movers.add(mover);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHistoryIncludes() {
        return this.historyIncludes;
    }

    public void setHistoryIncludes(String historyIncludes) {
        this.historyIncludes = historyIncludes;
    }

    public String getPackageFilter() {
        return this.packageFilter;
    }

    public void setPackageFilter(String packageFilter) {
        this.packageFilter = packageFilter;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public HistoricalAdded getAdded() {
        return this.added;
    }

    public List<HistoricalMover> getMovers() {
        return this.movers;
    }
}

