/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.changehandler.TransitionChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;

public class TransitionChangeHandlerCompat
extends ControllerChangeHandler {
    private static final String KEY_CHANGE_HANDLER_CLASS = "TransitionChangeHandlerCompat.changeHandler.class";
    private static final String KEY_HANDLER_STATE = "TransitionChangeHandlerCompat.changeHandler.state";
    @Nullable
    private ControllerChangeHandler changeHandler;

    public TransitionChangeHandlerCompat() {
    }

    public TransitionChangeHandlerCompat(@NonNull TransitionChangeHandler transitionChangeHandler, @NonNull ControllerChangeHandler fallbackChangeHandler) {
        this.changeHandler = Build.VERSION.SDK_INT >= 21 ? transitionChangeHandler : fallbackChangeHandler;
    }

    @Override
    public void performChange(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush, @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (this.changeHandler != null) {
            this.changeHandler.performChange(container, from, to, isPush, changeListener);
        }
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        if (this.changeHandler != null) {
            bundle.putString(KEY_CHANGE_HANDLER_CLASS, this.changeHandler.getClass().getName());
        }
        Bundle stateBundle = new Bundle();
        if (this.changeHandler != null) {
            this.changeHandler.saveToBundle(stateBundle);
        }
        bundle.putBundle(KEY_HANDLER_STATE, stateBundle);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        String className = bundle.getString(KEY_CHANGE_HANDLER_CLASS);
        this.changeHandler = (ControllerChangeHandler)ClassUtils.newInstance(className);
        this.changeHandler.restoreFromBundle(bundle.getBundle(KEY_HANDLER_STATE));
    }

    @Override
    public boolean removesFromViewOnPush() {
        if (this.changeHandler != null) {
            return this.changeHandler.removesFromViewOnPush();
        }
        return true;
    }

    @Override
    @NonNull
    public ControllerChangeHandler copy() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new TransitionChangeHandlerCompat((TransitionChangeHandler)this.changeHandler.copy(), null);
        }
        return new TransitionChangeHandlerCompat(null, this.changeHandler.copy());
    }

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
        if (this.changeHandler != null) {
            this.changeHandler.onAbortPush(newHandler, newTop);
        }
    }

    @Override
    public void completeImmediately() {
        if (this.changeHandler != null) {
            this.changeHandler.completeImmediately();
        }
    }

    @Override
    public void setForceRemoveViewOnPush(boolean force) {
        if (this.changeHandler != null) {
            this.changeHandler.setForceRemoveViewOnPush(force);
        }
    }

    @Override
    protected void onEnd() {
        this.changeHandler = null;
    }
}

