/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

@TargetApi(value=21)
public abstract class TransitionChangeHandler
extends ControllerChangeHandler {
    private boolean canceled;
    private boolean needsImmediateCompletion;

    @NonNull
    protected abstract Transition getTransition(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4);

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
        super.onAbortPush(newHandler, newTop);
        this.canceled = true;
    }

    @Override
    public void completeImmediately() {
        super.completeImmediately();
        this.needsImmediateCompletion = true;
    }

    @Override
    public void performChange(final @NonNull ViewGroup container, final @Nullable View from, final @Nullable View to, final boolean isPush, final @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (this.canceled) {
            changeListener.onChangeCompleted();
            return;
        }
        if (this.needsImmediateCompletion) {
            this.executePropertyChanges(container, from, to, null, isPush);
            changeListener.onChangeCompleted();
            return;
        }
        final Transition transition = this.getTransition(container, from, to, isPush);
        transition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
            }

            public void onTransitionEnd(Transition transition) {
                changeListener.onChangeCompleted();
            }

            public void onTransitionCancel(Transition transition) {
                changeListener.onChangeCompleted();
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
        this.prepareForTransition(container, from, to, transition, isPush, new OnTransitionPreparedListener(){

            @Override
            public void onPrepared() {
                if (!TransitionChangeHandler.this.canceled) {
                    TransitionManager.beginDelayedTransition((ViewGroup)container, (Transition)transition);
                    TransitionChangeHandler.this.executePropertyChanges(container, from, to, transition, isPush);
                }
            }
        });
    }

    @Override
    public boolean removesFromViewOnPush() {
        return true;
    }

    public void prepareForTransition(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, @NonNull Transition transition, boolean isPush, @NonNull OnTransitionPreparedListener onTransitionPreparedListener) {
        onTransitionPreparedListener.onPrepared();
    }

    public void executePropertyChanges(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, @Nullable Transition transition, boolean isPush) {
        if (from != null && (this.removesFromViewOnPush() || !isPush) && from.getParent() == container) {
            container.removeView(from);
        }
        if (to != null && to.getParent() == null) {
            container.addView(to);
        }
    }

    public static interface OnTransitionPreparedListener {
        public void onPrepared();
    }
}

