/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ActivityHostedRouter;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.internal.StringSparseArrayParceler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LifecycleHandler
extends Fragment
implements Application.ActivityLifecycleCallbacks {
    private static final String FRAGMENT_TAG = "LifecycleHandler";
    private static final String KEY_PENDING_PERMISSION_REQUESTS = "LifecycleHandler.pendingPermissionRequests";
    private static final String KEY_PERMISSION_REQUEST_CODES = "LifecycleHandler.permissionRequests";
    private static final String KEY_ACTIVITY_REQUEST_CODES = "LifecycleHandler.activityRequests";
    private static final String KEY_ROUTER_STATE_PREFIX = "LifecycleHandler.routerState";
    private Activity activity;
    private boolean hasRegisteredCallbacks;
    private boolean destroyed;
    private boolean attached;
    private SparseArray<String> permissionRequestMap = new SparseArray();
    private SparseArray<String> activityRequestMap = new SparseArray();
    private ArrayList<PendingPermissionRequest> pendingPermissionRequests = new ArrayList();
    private final Map<Integer, ActivityHostedRouter> routerMap = new HashMap<Integer, ActivityHostedRouter>();

    public LifecycleHandler() {
        this.setRetainInstance(true);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    private static LifecycleHandler findInActivity(@NonNull Activity activity) {
        LifecycleHandler lifecycleHandler = (LifecycleHandler)activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (lifecycleHandler != null) {
            lifecycleHandler.registerActivityListener(activity);
        }
        return lifecycleHandler;
    }

    @NonNull
    public static LifecycleHandler install(@NonNull Activity activity) {
        LifecycleHandler lifecycleHandler = LifecycleHandler.findInActivity(activity);
        if (lifecycleHandler == null) {
            lifecycleHandler = new LifecycleHandler();
            activity.getFragmentManager().beginTransaction().add((Fragment)lifecycleHandler, FRAGMENT_TAG).commit();
        }
        lifecycleHandler.registerActivityListener(activity);
        return lifecycleHandler;
    }

    @NonNull
    public Router getRouter(@NonNull ViewGroup container, @Nullable Bundle savedInstanceState) {
        ActivityHostedRouter router = this.routerMap.get(LifecycleHandler.getRouterHashKey(container));
        if (router == null) {
            Bundle routerSavedState;
            router = new ActivityHostedRouter();
            router.setHost(this, container);
            if (savedInstanceState != null && (routerSavedState = savedInstanceState.getBundle(KEY_ROUTER_STATE_PREFIX + router.getContainerId())) != null) {
                router.restoreInstanceState(routerSavedState);
            }
            this.routerMap.put(LifecycleHandler.getRouterHashKey(container), router);
        } else {
            router.setHost(this, container);
        }
        return router;
    }

    @NonNull
    public List<Router> getRouters() {
        return new ArrayList<Router>(this.routerMap.values());
    }

    @Nullable
    public Activity getLifecycleActivity() {
        return this.activity;
    }

    private static int getRouterHashKey(@NonNull ViewGroup viewGroup) {
        return viewGroup.getId();
    }

    private void registerActivityListener(@NonNull Activity activity) {
        this.activity = activity;
        if (!this.hasRegisteredCallbacks) {
            this.hasRegisteredCallbacks = true;
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            StringSparseArrayParceler permissionParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_PERMISSION_REQUEST_CODES);
            this.permissionRequestMap = permissionParcel != null ? permissionParcel.getStringSparseArray() : new SparseArray();
            StringSparseArrayParceler activityParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_ACTIVITY_REQUEST_CODES);
            this.activityRequestMap = activityParcel != null ? activityParcel.getStringSparseArray() : new SparseArray();
            ArrayList pendingRequests = savedInstanceState.getParcelableArrayList(KEY_PENDING_PERMISSION_REQUESTS);
            this.pendingPermissionRequests = pendingRequests != null ? pendingRequests : new ArrayList();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_PERMISSION_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.permissionRequestMap));
        outState.putParcelable(KEY_ACTIVITY_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.activityRequestMap));
        outState.putParcelableArrayList(KEY_PENDING_PERMISSION_REQUESTS, this.pendingPermissionRequests);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.activity != null) {
            this.activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.destroyRouters();
            this.activity = null;
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.destroyed = false;
        this.setAttached();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.destroyed = false;
        this.setAttached();
    }

    public void onDetach() {
        super.onDetach();
        this.attached = false;
        this.destroyRouters();
    }

    private void setAttached() {
        if (!this.attached) {
            this.attached = true;
            for (int i = this.pendingPermissionRequests.size() - 1; i >= 0; --i) {
                PendingPermissionRequest request = this.pendingPermissionRequests.remove(i);
                this.requestPermissions(request.instanceId, request.permissions, request.requestCode);
            }
        }
    }

    private void destroyRouters() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.activity != null) {
                for (Router router : this.routerMap.values()) {
                    router.onActivityDestroyed(this.activity);
                }
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        String instanceId = (String)this.activityRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.routerMap.values()) {
                router.onActivityResult(instanceId, requestCode, resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        String instanceId = (String)this.permissionRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.routerMap.values()) {
                router.onRequestPermissionsResult(instanceId, requestCode, permissions, grantResults);
            }
        }
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        for (Router router : this.routerMap.values()) {
            Boolean handled = router.handleRequestedPermission(permission);
            if (handled == null) continue;
            return handled;
        }
        return super.shouldShowRequestPermissionRationale(permission);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        for (Router router : this.routerMap.values()) {
            router.onCreateOptionsMenu(menu, inflater);
        }
    }

    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        for (Router router : this.routerMap.values()) {
            router.onPrepareOptionsMenu(menu);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        for (Router router : this.routerMap.values()) {
            if (!router.onOptionsItemSelected(item)) continue;
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void registerForActivityResult(@NonNull String instanceId, int requestCode) {
        this.activityRequestMap.put(requestCode, (Object)instanceId);
    }

    public void unregisterForActivityResults(@NonNull String instanceId) {
        for (int i = this.activityRequestMap.size() - 1; i >= 0; --i) {
            if (!instanceId.equals(this.activityRequestMap.get(this.activityRequestMap.keyAt(i)))) continue;
            this.activityRequestMap.removeAt(i);
        }
    }

    public void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode) {
        this.registerForActivityResult(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        this.registerForActivityResult(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode, options);
    }

    @TargetApi(value=24)
    public void startIntentSenderForResult(@NonNull String instanceId, @NonNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        this.registerForActivityResult(instanceId, requestCode);
        this.startIntentSenderForResult(intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @TargetApi(value=23)
    public void requestPermissions(@NonNull String instanceId, @NonNull String[] permissions, int requestCode) {
        if (this.attached) {
            this.permissionRequestMap.put(requestCode, (Object)instanceId);
            this.requestPermissions(permissions, requestCode);
        } else {
            this.pendingPermissionRequests.add(new PendingPermissionRequest(instanceId, permissions, requestCode));
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.activity == null && LifecycleHandler.findInActivity(activity) == this) {
            this.activity = activity;
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityStarted(activity);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityResumed(activity);
            }
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityPaused(activity);
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityStopped(activity);
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                Bundle bundle = new Bundle();
                router.saveInstanceState(bundle);
                outState.putBundle(KEY_ROUTER_STATE_PREFIX + router.getContainerId(), bundle);
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private static class PendingPermissionRequest
    implements Parcelable {
        final String instanceId;
        final String[] permissions;
        final int requestCode;
        public static final Parcelable.Creator<PendingPermissionRequest> CREATOR = new Parcelable.Creator<PendingPermissionRequest>(){

            public PendingPermissionRequest createFromParcel(Parcel in) {
                return new PendingPermissionRequest(in);
            }

            public PendingPermissionRequest[] newArray(int size) {
                return new PendingPermissionRequest[size];
            }
        };

        PendingPermissionRequest(@NonNull String instanceId, @NonNull String[] permissions, int requestCode) {
            this.instanceId = instanceId;
            this.permissions = permissions;
            this.requestCode = requestCode;
        }

        private PendingPermissionRequest(Parcel in) {
            this.instanceId = in.readString();
            this.permissions = in.createStringArray();
            this.requestCode = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.instanceId);
            out.writeStringArray(this.permissions);
            out.writeInt(this.requestCode);
        }
    }
}

