/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.internal.TransactionIndexer;
import java.util.ArrayList;
import java.util.List;

class ControllerHostedRouter
extends Router {
    private final String KEY_HOST_ID = "ControllerHostedRouter.hostId";
    private final String KEY_TAG = "ControllerHostedRouter.tag";
    private Controller hostController;
    @IdRes
    private int hostId;
    private String tag;

    ControllerHostedRouter() {
    }

    ControllerHostedRouter(int hostId, @Nullable String tag) {
        this.hostId = hostId;
        this.tag = tag;
    }

    final void setHost(@NonNull Controller controller, @NonNull ViewGroup container) {
        if (this.hostController != controller || this.container != container) {
            this.removeHost();
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.hostController = controller;
            this.container = container;
        }
    }

    final void removeHost() {
        if (this.container != null && this.container instanceof ControllerChangeHandler.ControllerChangeListener) {
            this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.container);
        }
        ArrayList controllersToDestroy = new ArrayList(this.destroyingControllers);
        for (Controller controller : controllersToDestroy) {
            if (controller.getView() == null) continue;
            controller.detach(controller.getView(), true, false);
        }
        for (RouterTransaction transaction : this.backstack) {
            if (transaction.controller.getView() == null) continue;
            transaction.controller.detach(transaction.controller.getView(), true, false);
        }
        this.prepareForContainerRemoval();
        this.hostController = null;
        this.container = null;
    }

    final void setDetachFrozen(boolean frozen) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.setDetachFrozen(frozen);
        }
    }

    @Override
    void destroy(boolean popViews) {
        this.setDetachFrozen(false);
        super.destroy(popViews);
    }

    @Override
    @Nullable
    public Activity getActivity() {
        return this.hostController != null ? this.hostController.getActivity() : null;
    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {
        super.onActivityDestroyed(activity);
        this.removeHost();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().invalidateOptionsMenu();
        }
    }

    @Override
    void startActivity(@NonNull Intent intent) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivity(intent);
        }
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode);
        }
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode, options);
        }
    }

    @Override
    void registerForActivityResult(@NonNull String instanceId, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().registerForActivityResult(instanceId, requestCode);
        }
    }

    @Override
    void unregisterForActivityResults(@NonNull String instanceId) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().unregisterForActivityResults(instanceId);
        }
    }

    @Override
    void requestPermissions(@NonNull String instanceId, @NonNull String[] permissions, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().requestPermissions(instanceId, permissions, requestCode);
        }
    }

    @Override
    boolean hasHost() {
        return this.hostController != null;
    }

    @Override
    public void saveInstanceState(@NonNull Bundle outState) {
        super.saveInstanceState(outState);
        outState.putInt("ControllerHostedRouter.hostId", this.hostId);
        outState.putString("ControllerHostedRouter.tag", this.tag);
    }

    @Override
    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.restoreInstanceState(savedInstanceState);
        this.hostId = savedInstanceState.getInt("ControllerHostedRouter.hostId");
        this.tag = savedInstanceState.getString("ControllerHostedRouter.tag");
    }

    @Override
    void setControllerRouter(@NonNull Controller controller) {
        super.setControllerRouter(controller);
        controller.setParentController(this.hostController);
    }

    int getHostId() {
        return this.hostId;
    }

    @Nullable
    String getTag() {
        return this.tag;
    }

    @Override
    @NonNull
    List<Router> getSiblingRouters() {
        ArrayList<Router> list = new ArrayList<Router>();
        list.addAll(this.hostController.getChildRouters());
        list.addAll(this.hostController.getRouter().getSiblingRouters());
        return list;
    }

    @Override
    @NonNull
    Router getRootRouter() {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            return this.hostController.getRouter().getRootRouter();
        }
        return this;
    }

    @Override
    @Nullable
    TransactionIndexer getTransactionIndexer() {
        return this.getRootRouter().getTransactionIndexer();
    }
}

