/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

public class ClassUtils {
    @Nullable
    public static <T> Class<? extends T> classForName(@NonNull String className, boolean allowEmptyName) {
        if (allowEmptyName && TextUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while finding class for name " + className + ". " + e.getMessage());
        }
    }

    @Nullable
    public static <T> T newInstance(@NonNull String className) {
        try {
            Class<T> cls = ClassUtils.classForName(className, true);
            return cls != null ? (T)cls.newInstance() : null;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while creating a new instance of " + className + ". " + e.getMessage());
        }
    }
}

