/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class Backstack
implements Iterable<RouterTransaction> {
    private static final String KEY_ENTRIES = "Backstack.entries";
    private final Deque<RouterTransaction> backStack = new ArrayDeque<RouterTransaction>();

    Backstack() {
    }

    public boolean isEmpty() {
        return this.backStack.isEmpty();
    }

    public int size() {
        return this.backStack.size();
    }

    @Nullable
    public RouterTransaction root() {
        return this.backStack.size() > 0 ? this.backStack.getLast() : null;
    }

    @Override
    @NonNull
    public Iterator<RouterTransaction> iterator() {
        return this.backStack.iterator();
    }

    @NonNull
    public Iterator<RouterTransaction> reverseIterator() {
        return this.backStack.descendingIterator();
    }

    @NonNull
    public List<RouterTransaction> popTo(@NonNull RouterTransaction transaction) {
        ArrayList<RouterTransaction> popped = new ArrayList<RouterTransaction>();
        if (this.backStack.contains(transaction)) {
            while (this.backStack.peek() != transaction) {
                RouterTransaction poppedTransaction = this.pop();
                popped.add(poppedTransaction);
            }
        } else {
            throw new RuntimeException("Tried to pop to a transaction that was not on the back stack");
        }
        return popped;
    }

    @NonNull
    public RouterTransaction pop() {
        RouterTransaction popped = this.backStack.pop();
        popped.controller.destroy();
        return popped;
    }

    @Nullable
    public RouterTransaction peek() {
        return this.backStack.peek();
    }

    public void remove(@NonNull RouterTransaction transaction) {
        this.backStack.removeFirstOccurrence(transaction);
    }

    public void push(@NonNull RouterTransaction transaction) {
        this.backStack.push(transaction);
    }

    @NonNull
    public List<RouterTransaction> popAll() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        while (!this.isEmpty()) {
            list.add(this.pop());
        }
        return list;
    }

    public void setBackstack(@NonNull List<RouterTransaction> backstack) {
        for (RouterTransaction existingTransaction : this.backStack) {
            boolean contains = false;
            for (RouterTransaction newTransaction : backstack) {
                if (existingTransaction.controller != newTransaction.controller) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            existingTransaction.controller.destroy();
        }
        this.backStack.clear();
        for (RouterTransaction transaction : backstack) {
            this.backStack.push(transaction);
        }
    }

    public void saveInstanceState(@NonNull Bundle outState) {
        ArrayList<Bundle> entryBundles = new ArrayList<Bundle>(this.backStack.size());
        for (RouterTransaction entry : this.backStack) {
            entryBundles.add(entry.saveInstanceState());
        }
        outState.putParcelableArrayList(KEY_ENTRIES, entryBundles);
    }

    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        ArrayList entryBundles = savedInstanceState.getParcelableArrayList(KEY_ENTRIES);
        if (entryBundles != null) {
            Collections.reverse(entryBundles);
            for (Bundle transactionBundle : entryBundles) {
                this.backStack.push(new RouterTransaction(transactionBundle));
            }
        }
    }
}

