/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.changehandler.TransitionChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;

public class TransitionChangeHandlerCompat
extends ControllerChangeHandler {
    private static final String KEY_TRANSITION_HANDLER_CLASS = "TransitionChangeHandlerCompat.transitionChangeHandler.class";
    private static final String KEY_FALLBACK_HANDLER_CLASS = "TransitionChangeHandlerCompat.fallbackChangeHandler.class";
    private static final String KEY_TRANSITION_HANDLER_STATE = "TransitionChangeHandlerCompat.transitionChangeHandler.state";
    private static final String KEY_FALLBACK_HANDLER_STATE = "TransitionChangeHandlerCompat.fallbackChangeHandler.state";
    private TransitionChangeHandler transitionChangeHandler;
    private ControllerChangeHandler fallbackChangeHandler;

    public TransitionChangeHandlerCompat() {
    }

    public TransitionChangeHandlerCompat(TransitionChangeHandler transitionChangeHandler, ControllerChangeHandler fallbackChangeHandler) {
        this.transitionChangeHandler = transitionChangeHandler;
        this.fallbackChangeHandler = fallbackChangeHandler;
    }

    @Override
    public void performChange(@NonNull ViewGroup container, View from, View to, boolean isPush, @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.transitionChangeHandler.performChange(container, from, to, isPush, changeListener);
        } else {
            this.fallbackChangeHandler.performChange(container, from, to, isPush, changeListener);
        }
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        bundle.putString(KEY_TRANSITION_HANDLER_CLASS, this.transitionChangeHandler.getClass().getName());
        bundle.putString(KEY_FALLBACK_HANDLER_CLASS, this.fallbackChangeHandler.getClass().getName());
        Bundle transitionBundle = new Bundle();
        this.transitionChangeHandler.saveToBundle(transitionBundle);
        bundle.putBundle(KEY_TRANSITION_HANDLER_STATE, transitionBundle);
        Bundle fallbackBundle = new Bundle();
        this.fallbackChangeHandler.saveToBundle(fallbackBundle);
        bundle.putBundle(KEY_FALLBACK_HANDLER_STATE, fallbackBundle);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        String transitionClassName = bundle.getString(KEY_TRANSITION_HANDLER_CLASS);
        this.transitionChangeHandler = (TransitionChangeHandler)ClassUtils.newInstance(transitionClassName);
        this.transitionChangeHandler.restoreFromBundle(bundle.getBundle(KEY_TRANSITION_HANDLER_STATE));
        String fallbackClassName = bundle.getString(KEY_FALLBACK_HANDLER_CLASS);
        this.fallbackChangeHandler = (ControllerChangeHandler)ClassUtils.newInstance(fallbackClassName);
        this.fallbackChangeHandler.restoreFromBundle(bundle.getBundle(KEY_FALLBACK_HANDLER_STATE));
    }

    @Override
    public boolean removesFromViewOnPush() {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.transitionChangeHandler.removesFromViewOnPush();
        }
        return this.fallbackChangeHandler.removesFromViewOnPush();
    }
}

