/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.lint;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeMember;

public final class ControllerChangeHandlerIssueDetector
extends Detector
implements Detector.JavaScanner,
Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"ValidControllerChangeHandler", (String)"ControllerChangeHandler not instantiatable", (String)"Non-abstract ControllerChangeHandler instances must have a default constructor for the system to re-create them in the case of the process being killed.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(ControllerChangeHandlerIssueDetector.class, Scope.JAVA_FILE_SCOPE));

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("com.bluelinelabs.conductor.ControllerChangeHandler");
    }

    public void checkClass(JavaContext context, ClassDeclaration node, Node declarationOrAnonymous, JavaParser.ResolvedClass cls) {
        if (node == null) {
            return;
        }
        int flags = node.astModifiers().getEffectiveModifierFlags();
        if ((flags & 0x400) != 0) {
            return;
        }
        if ((flags & 1) == 0) {
            String message = String.format("This ControllerChangeHandler class should be public (%1$s)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
            return;
        }
        if (cls.getContainingClass() != null && (flags & 8) == 0) {
            String message = String.format("This ControllerChangeHandler inner class should be static (%1$s)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
            return;
        }
        boolean hasConstructor = false;
        boolean hasDefaultConstructor = false;
        NormalTypeBody body = node.astBody();
        if (body != null) {
            for (TypeMember member : body.astMembers()) {
                StrictListAccessor params;
                if (!(member instanceof ConstructorDeclaration)) continue;
                hasConstructor = true;
                ConstructorDeclaration constructor = (ConstructorDeclaration)member;
                if (!constructor.astModifiers().isPublic() || !(params = constructor.astParameters()).isEmpty()) continue;
                hasDefaultConstructor = true;
                break;
            }
        }
        if (hasConstructor && !hasDefaultConstructor) {
            String message = String.format("This ControllerChangeHandler needs to have a public default constructor (`%1$s`)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
        }
    }
}

