/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayList;
import java.util.List;

public class ControllerHostedRouter
extends Router {
    private final String KEY_HOST_ID = "ControllerHostedRouter.hostId";
    private final String KEY_TAG = "ControllerHostedRouter.tag";
    private Controller mHostController;
    @IdRes
    private int mHostId;
    private String mTag;

    public ControllerHostedRouter() {
    }

    public ControllerHostedRouter(int hostId, String tag) {
        this.mHostId = hostId;
        this.mTag = tag;
    }

    public final void setHost(@NonNull Controller controller, @NonNull ViewGroup container) {
        if (this.mHostController != controller || this.mContainer != container) {
            this.removeHost();
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.mHostController = controller;
            this.mContainer = container;
        }
    }

    public final void removeHost() {
        if (this.mContainer != null && this.mContainer instanceof ControllerChangeHandler.ControllerChangeListener) {
            this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.mContainer);
        }
        this.prepareForContainerRemoval();
        this.mHostController = null;
        this.mContainer = null;
    }

    public final void setDetachFrozen(boolean frozen) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.setDetachFrozen(frozen);
        }
    }

    @Override
    public Activity getActivity() {
        return this.mHostController != null ? this.mHostController.getActivity() : null;
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        super.onActivityDestroyed(activity);
        this.removeHost();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().invalidateOptionsMenu();
        }
    }

    @Override
    void startActivity(Intent intent) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().startActivity(intent);
        }
    }

    @Override
    void startActivityForResult(String instanceId, Intent intent, int requestCode) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().startActivityForResult(instanceId, intent, requestCode);
        }
    }

    @Override
    void startActivityForResult(String instanceId, Intent intent, int requestCode, Bundle options) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().startActivityForResult(instanceId, intent, requestCode, options);
        }
    }

    @Override
    void registerForActivityResult(String instanceId, int requestCode) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().registerForActivityResult(instanceId, requestCode);
        }
    }

    @Override
    void unregisterForActivityResults(String instanceId) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().unregisterForActivityResults(instanceId);
        }
    }

    @Override
    void requestPermissions(String instanceId, String[] permissions, int requestCode) {
        if (this.mHostController != null && this.mHostController.getRouter() != null) {
            this.mHostController.getRouter().requestPermissions(instanceId, permissions, requestCode);
        }
    }

    @Override
    boolean hasHost() {
        return this.mHostController != null;
    }

    @Override
    public void saveInstanceState(Bundle outState) {
        super.saveInstanceState(outState);
        outState.putInt("ControllerHostedRouter.hostId", this.mHostId);
        outState.putString("ControllerHostedRouter.tag", this.mTag);
    }

    @Override
    public void restoreInstanceState(Bundle savedInstanceState) {
        super.restoreInstanceState(savedInstanceState);
        this.mHostId = savedInstanceState.getInt("ControllerHostedRouter.hostId");
        this.mTag = savedInstanceState.getString("ControllerHostedRouter.tag");
    }

    @Override
    void setControllerRouter(Controller controller) {
        super.setControllerRouter(controller);
        controller.setParentController(this.mHostController);
    }

    public int getHostId() {
        return this.mHostId;
    }

    public String getTag() {
        return this.mTag;
    }

    @Override
    List<Router> getSiblingRouters() {
        ArrayList<Router> list = new ArrayList<Router>();
        list.addAll(this.mHostController.getChildRouters());
        list.addAll(this.mHostController.getRouter().getSiblingRouters());
        return list;
    }
}

