/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ChildControllerTransaction;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerTransaction;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;
import com.bluelinelabs.conductor.internal.RouterRequiringFunc;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public abstract class Controller {
    private static final String KEY_CLASS_NAME = "Controller.className";
    private static final String KEY_VIEW_STATE = "Controller.viewState";
    private static final String KEY_CHILDREN = "Controller.childControllers";
    private static final String KEY_SAVED_STATE = "Controller.savedState";
    private static final String KEY_INSTANCE_ID = "Controller.instanceId";
    private static final String KEY_TARGET_INSTANCE_ID = "Controller.target.instanceId";
    private static final String KEY_ARGS = "Controller.args";
    private static final String KEY_NEEDS_ATTACH = "Controller.needsAttach";
    private static final String KEY_REQUESTED_PERMISSIONS = "Controller.childControllers";
    private static final String KEY_OVERRIDDEN_PUSH_HANDLER = "Controller.overriddenPushHandler";
    private static final String KEY_OVERRIDDEN_POP_HANDLER = "Controller.overriddenPopHandler";
    private static final String KEY_VIEW_STATE_HIERARCHY = "Controller.viewState.hierarchy";
    private static final String KEY_VIEW_STATE_BUNDLE = "Controller.viewState.bundle";
    private final Bundle mArgs;
    private Bundle mViewState;
    private boolean mIsBeingDestroyed;
    private boolean mDestroyed;
    private boolean mAttached;
    private boolean mHasOptionsMenu;
    private boolean mOptionsMenuHidden;
    private boolean mViewIsAttached;
    private Router mRouter;
    private View mView;
    private Controller mParentController;
    private String mInstanceId;
    private String mTargetInstanceId;
    private boolean mNeedsAttach;
    private ControllerChangeHandler mOverriddenPushHandler;
    private ControllerChangeHandler mOverriddenPopHandler;
    private RetainViewMode mRetainViewMode = RetainViewMode.RELEASE_DETACH;
    private final List<ChildControllerTransaction> mChildControllers = new ArrayList<ChildControllerTransaction>();
    private final List<LifecycleListener> mLifecycleListeners = new ArrayList<LifecycleListener>();
    private final ArrayList<String> mRequestedPermissions = new ArrayList();
    private final ArrayList<RouterRequiringFunc> mOnRouterSetListeners = new ArrayList();

    static Controller newInstance(Bundle bundle) {
        Controller controller;
        String className = bundle.getString(KEY_CLASS_NAME);
        Constructor[] constructors = ClassUtils.classForName(className, false).getConstructors();
        Constructor bundleConstructor = Controller.getBundleConstructor(constructors);
        try {
            controller = bundleConstructor != null ? (Controller)bundleConstructor.newInstance(bundle.getBundle(KEY_ARGS)) : (Controller)Controller.getDefaultConstructor(constructors).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while creating a new instance of " + className + ". " + e.getMessage());
        }
        controller.restoreInstanceState(bundle);
        return controller;
    }

    protected Controller() {
        this(null);
    }

    protected Controller(Bundle args) {
        this.mArgs = args;
        this.mInstanceId = UUID.randomUUID().toString();
        this.ensureRequiredConstructor();
    }

    @NonNull
    protected abstract View onCreateView(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    public final Router getRouter() {
        return this.mRouter;
    }

    public Bundle getArgs() {
        return this.mArgs;
    }

    public void addChildController(ChildControllerTransaction transaction) {
        this.addChildController(transaction, transaction.getPushControllerChangeHandler());
    }

    public void removeChildController(Controller controller) {
        for (int i = this.mChildControllers.size() - 1; i >= 0; --i) {
            ChildControllerTransaction childTransaction = this.mChildControllers.get(i);
            if (childTransaction.controller != controller) continue;
            childTransaction.controller.destroy();
            childTransaction.controller.mParentController = null;
            if (controller.mView != null && controller.mView.getParent() != null) {
                ViewGroup container = (ViewGroup)controller.mView.getParent();
                ControllerChangeHandler.executeChange(null, controller, false, container, childTransaction.getPopControllerChangeHandler());
            }
            this.mChildControllers.remove(i);
            break;
        }
    }

    public final boolean isDestroyed() {
        return this.mDestroyed;
    }

    public final boolean isBeingDestroyed() {
        return this.mIsBeingDestroyed;
    }

    public final boolean isAttached() {
        return this.mAttached;
    }

    public final View getView() {
        return this.mView;
    }

    public final Activity getActivity() {
        return this.mRouter.getActivity();
    }

    public final Resources getResources() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getResources() : null;
    }

    public final Context getApplicationContext() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getApplicationContext() : null;
    }

    public final Controller getParentController() {
        return this.mParentController;
    }

    public final String getInstanceId() {
        return this.mInstanceId;
    }

    public final Controller getChildController(String tag) {
        for (ControllerTransaction controllerTransaction : this.mChildControllers) {
            if (!tag.equals(controllerTransaction.tag)) continue;
            return controllerTransaction.controller;
        }
        return null;
    }

    public final Controller getChildControllerWithInstanceId(String instanceId) {
        for (ControllerTransaction controllerTransaction : this.mChildControllers) {
            if (!controllerTransaction.controller.getInstanceId().equals(instanceId)) continue;
            return controllerTransaction.controller;
        }
        return null;
    }

    public final List<Controller> getChildControllers() {
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        for (ControllerTransaction controllerTransaction : this.mChildControllers) {
            controllers.add(controllerTransaction.controller);
        }
        return controllers;
    }

    public void setTargetController(Controller target) {
        if (this.mTargetInstanceId != null) {
            throw new RuntimeException("Target controller already set. A controller's target may only be set once.");
        }
        this.mTargetInstanceId = target != null ? target.getInstanceId() : null;
    }

    public final Controller getTargetController() {
        return this.mTargetInstanceId != null ? this.mRouter.getControllerWithInstanceId(this.mTargetInstanceId) : null;
    }

    protected void onDestroyView(View view) {
    }

    protected void onChangeStarted(@NonNull ControllerChangeHandler changeHandler, @NonNull ControllerTransaction.ControllerChangeType changeType) {
    }

    protected void onChangeEnded(@NonNull ControllerChangeHandler changeHandler, @NonNull ControllerTransaction.ControllerChangeType changeType) {
    }

    protected void onAttach(@NonNull View view) {
    }

    protected void onDetach(@NonNull View view) {
    }

    protected void onDestroy() {
    }

    protected void onActivityStarted(Activity activity) {
    }

    protected void onActivityResumed(Activity activity) {
    }

    protected void onActivityPaused(Activity activity) {
    }

    protected void onActivityStopped(Activity activity) {
    }

    protected void onSaveViewState(@NonNull View view, @NonNull Bundle outState) {
    }

    protected void onRestoreViewState(@NonNull View view, @NonNull Bundle savedViewState) {
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
    }

    public final void startActivity(final Intent intent) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.getLifecycleHandler().startActivity(intent);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.getLifecycleHandler().startActivityForResult(Controller.this.mInstanceId, intent, requestCode);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode, final Bundle options) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.getLifecycleHandler().startActivityForResult(Controller.this.mInstanceId, intent, requestCode, options);
            }
        });
    }

    public final void registerForActivityResult(final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.getLifecycleHandler().registerForActivityRequest(Controller.this.mInstanceId, requestCode);
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @TargetApi(value=23)
    public final void requestPermissions(final @NonNull String[] permissions, final int requestCode) {
        this.mRequestedPermissions.addAll(Arrays.asList(permissions));
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.getLifecycleHandler().requestPermissions(Controller.this.mInstanceId, permissions, requestCode);
            }
        });
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    public boolean handleBack() {
        for (int i = this.mChildControllers.size() - 1; i >= 0; --i) {
            ChildControllerTransaction transaction = this.mChildControllers.get(i);
            if (!transaction.addToLocalBackstack) continue;
            this.removeChildController(transaction.controller);
            return true;
        }
        return false;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        if (!this.mLifecycleListeners.contains(lifecycleListener)) {
            this.mLifecycleListeners.add(lifecycleListener);
        }
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.mLifecycleListeners.remove(lifecycleListener);
    }

    public RetainViewMode getRetainViewMode() {
        return this.mRetainViewMode;
    }

    public void setRetainViewMode(RetainViewMode retainViewMode) {
        this.mRetainViewMode = retainViewMode;
        if (this.mRetainViewMode == RetainViewMode.RELEASE_DETACH && !this.mAttached) {
            this.removeViewReference();
        }
    }

    public final ControllerChangeHandler getOverriddenPushHandler() {
        return this.mOverriddenPushHandler;
    }

    public void overridePushHandler(ControllerChangeHandler overriddenPushHandler) {
        this.mOverriddenPushHandler = overriddenPushHandler;
    }

    public ControllerChangeHandler getOverriddenPopHandler() {
        return this.mOverriddenPopHandler;
    }

    public void overridePopHandler(ControllerChangeHandler overriddenPopHandler) {
        this.mOverriddenPopHandler = overriddenPopHandler;
    }

    public final void setHasOptionsMenu(boolean hasOptionsMenu) {
        boolean invalidate = this.mAttached && !this.mOptionsMenuHidden && this.mHasOptionsMenu != hasOptionsMenu;
        this.mHasOptionsMenu = hasOptionsMenu;
        if (invalidate) {
            this.mRouter.invalidateOptionsMenu();
        }
    }

    public final void setOptionsMenuHidden(boolean optionsMenuHidden) {
        boolean invalidate = this.mAttached && this.mHasOptionsMenu && this.mOptionsMenuHidden != optionsMenuHidden;
        this.mOptionsMenuHidden = optionsMenuHidden;
        if (invalidate) {
            this.mRouter.invalidateOptionsMenu();
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
    }

    public void onPrepareOptionsMenu(Menu menu) {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    final void prepareForActivityPause() {
        this.mNeedsAttach = this.mNeedsAttach || this.mAttached;
    }

    final boolean getNeedsAttach() {
        return this.mNeedsAttach;
    }

    final boolean didRequestPermission(@NonNull String permission) {
        return this.mRequestedPermissions.contains(permission);
    }

    final void requestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.mRequestedPermissions.removeAll(Arrays.asList(permissions));
        this.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    final void setRouter(@NonNull Router router) {
        this.mRouter = router;
        for (RouterRequiringFunc listener : this.mOnRouterSetListeners) {
            listener.execute();
        }
        this.mOnRouterSetListeners.clear();
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.setRouter(router);
        }
    }

    final void executeWithRouter(@NonNull RouterRequiringFunc listener) {
        if (this.mRouter != null) {
            listener.execute();
        } else {
            this.mOnRouterSetListeners.add(listener);
        }
    }

    private void addChildController(ChildControllerTransaction transaction, ControllerChangeHandler pushChangeHandler) {
        if (transaction.controller.mParentController == null) {
            transaction.controller.setRouter(this.mRouter);
            transaction.controller.mParentController = this;
            this.mChildControllers.add(transaction);
        }
        this.attachChildController(transaction, pushChangeHandler);
    }

    private void attachChildController(ChildControllerTransaction transaction, ControllerChangeHandler pushChangeHandler) {
        View childView;
        ViewGroup container;
        if (this.mAttached && (container = (ViewGroup)this.mView.findViewById(transaction.containerId)) != null && ((childView = transaction.controller.mView) == null || childView.getParent() != container)) {
            Controller to = transaction.controller;
            ControllerChangeHandler.executeChange(to, null, true, container, pushChangeHandler);
        }
    }

    final void activityStarted(Activity activity) {
        this.onActivityStarted(activity);
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.activityStarted(activity);
        }
    }

    final void activityResumed(Activity activity) {
        if (!this.mAttached && this.mView != null && this.mViewIsAttached) {
            this.attach(this.mView);
        }
        this.onActivityResumed(activity);
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.activityResumed(activity);
        }
    }

    final void activityPaused(Activity activity) {
        this.onActivityPaused(activity);
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.activityPaused(activity);
        }
    }

    final void activityStopped(Activity activity) {
        this.onActivityStopped(activity);
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.activityStopped(activity);
        }
    }

    final void activityDestroyed(boolean isChangingConfigurations) {
        if (isChangingConfigurations) {
            this.removeViewReference();
        } else {
            this.destroy(true);
        }
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.activityDestroyed(isChangingConfigurations);
        }
    }

    private void attach(@NonNull View view) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.preAttach(this, view);
        }
        this.mAttached = true;
        this.mNeedsAttach = false;
        for (ChildControllerTransaction child : this.mChildControllers) {
            this.attachChildController(child, new SimpleSwapChangeHandler());
        }
        this.onAttach(view);
        if (this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.mRouter.invalidateOptionsMenu();
        }
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.postAttach(this, view);
        }
    }

    private void detach(@NonNull View view, boolean allowViewRefRemoval) {
        boolean removeViewRef;
        boolean bl = removeViewRef = allowViewRefRemoval && (this.mRetainViewMode == RetainViewMode.RELEASE_DETACH || this.mIsBeingDestroyed);
        if (this.mAttached) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDetach(this, view);
            }
            this.mAttached = false;
            this.onDetach(view);
            if (this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
                this.mRouter.invalidateOptionsMenu();
            }
            for (ChildControllerTransaction child : this.mChildControllers) {
                ViewGroup container = (ViewGroup)this.mView.findViewById(child.containerId);
                if (container == null) continue;
                container.removeView(child.controller.getView());
            }
            if (removeViewRef) {
                this.removeViewReference();
            }
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDetach(this, view);
            }
        } else if (removeViewRef) {
            this.removeViewReference();
        }
    }

    private void removeViewReference() {
        if (this.mView != null) {
            if (!this.mIsBeingDestroyed) {
                this.saveViewState(this.mView);
            }
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDestroyView(this, this.mView);
            }
            this.onDestroyView(this.mView);
            this.mView = null;
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDestroyView(this);
            }
        }
        if (this.mIsBeingDestroyed) {
            this.performDestroy();
        }
    }

    final View inflate(@NonNull ViewGroup parent) {
        if (this.mView == null) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preCreateView(this);
            }
            this.mView = this.onCreateView(LayoutInflater.from((Context)parent.getContext()), parent);
            this.restoreViewState(this.mView);
            this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    if (v == Controller.this.mView) {
                        Controller.this.mViewIsAttached = true;
                    }
                    Controller.this.attach(v);
                }

                public void onViewDetachedFromWindow(View v) {
                    Controller.this.mViewIsAttached = false;
                    Controller.this.detach(v, true);
                }
            });
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postCreateView(this, this.mView);
            }
        }
        return this.mView;
    }

    final void performDestroy() {
        if (!this.mDestroyed) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDestroy(this);
            }
            this.mDestroyed = true;
            if (this.mRouter != null) {
                this.mRouter.getLifecycleHandler().unregisterForActivityRequests(this.mInstanceId);
            }
            this.onDestroy();
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDestroy(this);
            }
        }
    }

    final void destroy() {
        this.destroy(false);
    }

    final void destroy(boolean removeViews) {
        this.mIsBeingDestroyed = true;
        for (ChildControllerTransaction child : this.mChildControllers) {
            child.controller.destroy(removeViews);
        }
        if (!this.mAttached) {
            this.removeViewReference();
        } else if (removeViews) {
            this.detach(this.mView, true);
        }
    }

    final void saveViewState(@NonNull View view) {
        this.mViewState = new Bundle();
        SparseArray hierarchyState = new SparseArray();
        view.saveHierarchyState(hierarchyState);
        this.mViewState.putSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY, hierarchyState);
        Bundle stateBundle = new Bundle();
        this.onSaveViewState(view, stateBundle);
        this.mViewState.putBundle(KEY_VIEW_STATE_BUNDLE, stateBundle);
        for (ChildControllerTransaction child : this.mChildControllers) {
            if (child.controller.mView == null) continue;
            child.controller.saveViewState(child.controller.mView);
        }
    }

    final void restoreViewState(@NonNull View view) {
        if (this.mViewState != null) {
            view.restoreHierarchyState(this.mViewState.getSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY));
            this.onRestoreViewState(view, this.mViewState.getBundle(KEY_VIEW_STATE_BUNDLE));
            for (ChildControllerTransaction child : this.mChildControllers) {
                if (child.controller.mView == null) continue;
                child.controller.restoreViewState(child.controller.mView);
            }
        }
    }

    final Bundle detachAndSaveInstanceState() {
        if (this.mAttached && this.mView != null) {
            this.detach(this.mView, this.mIsBeingDestroyed);
        }
        Bundle outState = new Bundle();
        outState.putString(KEY_CLASS_NAME, this.getClass().getCanonicalName());
        outState.putBundle(KEY_VIEW_STATE, this.mViewState);
        outState.putBundle(KEY_ARGS, this.mArgs);
        outState.putString(KEY_INSTANCE_ID, this.mInstanceId);
        outState.putString(KEY_TARGET_INSTANCE_ID, this.mTargetInstanceId);
        outState.putStringArrayList("Controller.childControllers", this.mRequestedPermissions);
        outState.putBoolean(KEY_NEEDS_ATTACH, this.mNeedsAttach || this.mAttached);
        if (this.mOverriddenPushHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_PUSH_HANDLER, this.mOverriddenPushHandler.toBundle());
        }
        if (this.mOverriddenPopHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_POP_HANDLER, this.mOverriddenPopHandler.toBundle());
        }
        ArrayList<Bundle> childBundles = new ArrayList<Bundle>();
        for (ChildControllerTransaction childController : this.mChildControllers) {
            childBundles.add(childController.detachAndSaveInstanceState());
        }
        outState.putParcelableArrayList("Controller.childControllers", childBundles);
        Bundle savedState = new Bundle();
        this.onSaveInstanceState(savedState);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onSaveInstanceState(this, savedState);
        }
        outState.putBundle(KEY_SAVED_STATE, savedState);
        return outState;
    }

    private void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.mViewState = savedInstanceState.getBundle(KEY_VIEW_STATE);
        this.mInstanceId = savedInstanceState.getString(KEY_INSTANCE_ID);
        this.mTargetInstanceId = savedInstanceState.getString(KEY_TARGET_INSTANCE_ID);
        this.mRequestedPermissions.addAll(savedInstanceState.getStringArrayList("Controller.childControllers"));
        this.mOverriddenPushHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_PUSH_HANDLER));
        this.mOverriddenPopHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_POP_HANDLER));
        this.mNeedsAttach = savedInstanceState.getBoolean(KEY_NEEDS_ATTACH);
        ArrayList childBundles = savedInstanceState.getParcelableArrayList("Controller.childControllers");
        for (Bundle childBundle : childBundles) {
            this.addChildController(new ChildControllerTransaction(childBundle));
        }
        Bundle savedState = savedInstanceState.getBundle(KEY_SAVED_STATE);
        this.onRestoreInstanceState(savedState);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onRestoreInstanceState(this, savedState);
        }
    }

    final void changeStarted(ControllerChangeHandler changeHandler, ControllerTransaction.ControllerChangeType changeType) {
        this.onChangeStarted(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onChangeStart(this, changeHandler, changeType);
        }
    }

    final void changeEnded(ControllerChangeHandler changeHandler, ControllerTransaction.ControllerChangeType changeType) {
        this.onChangeEnded(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onChangeEnd(this, changeHandler, changeType);
        }
    }

    final void createOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.onCreateOptionsMenu(menu, inflater);
        }
    }

    final void prepareOptionsMenu(Menu menu) {
        if (this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.onPrepareOptionsMenu(menu);
        }
    }

    final boolean optionsItemSelected(MenuItem item) {
        if (this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            return this.onOptionsItemSelected(item);
        }
        return false;
    }

    private void ensureRequiredConstructor() {
        Constructor[] constructors = this.getClass().getConstructors();
        if (Controller.getBundleConstructor(constructors) == null && Controller.getDefaultConstructor(constructors) == null) {
            throw new RuntimeException(this.getClass() + " does not have a constructor that takes a Bundle argument or a default constructor. Controllers must have one of these in order to restore their states.");
        }
    }

    private static Constructor getDefaultConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private static Constructor getBundleConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != Bundle.class) continue;
            return constructor;
        }
        return null;
    }

    public static abstract class LifecycleListener {
        public void onChangeStart(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerTransaction.ControllerChangeType changeType) {
        }

        public void onChangeEnd(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerTransaction.ControllerChangeType changeType) {
        }

        public void preCreateView(@NonNull Controller controller) {
        }

        public void postCreateView(@NonNull Controller controller, @NonNull View view) {
        }

        public void preAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDestroyView(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDestroyView(@NonNull Controller controller) {
        }

        public void preDestroy(@NonNull Controller controller) {
        }

        public void postDestroy(@NonNull Controller controller) {
        }

        public void onSaveInstanceState(@NonNull Controller controller, @NonNull Bundle outState) {
        }

        public void onRestoreInstanceState(@NonNull Controller controller, @NonNull Bundle savedInstanceState) {
        }
    }

    public static enum RetainViewMode {
        RELEASE_DETACH,
        RETAIN_DETACH;

    }
}

