/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.changehandler.AnimatorChangeHandler;

@TargetApi(value=21)
public class CircularRevealChangeHandler
extends AnimatorChangeHandler {
    private static final String KEY_CX = "CircularRevealChangeHandler.cx";
    private static final String KEY_CY = "CircularRevealChangeHandler.cy";
    private int mCx;
    private int mCy;

    public CircularRevealChangeHandler() {
    }

    public CircularRevealChangeHandler(@NonNull View fromView, @NonNull View containerView) {
        this(fromView, containerView, -1L);
    }

    public CircularRevealChangeHandler(@NonNull View fromView, @NonNull View containerView, long duration) {
        this(fromView, containerView, duration, true);
    }

    public CircularRevealChangeHandler(@NonNull View fromView, @NonNull View containerView, boolean removesFromViewOnPush) {
        this(fromView, containerView, -1L, true);
    }

    public CircularRevealChangeHandler(@NonNull View fromView, @NonNull View containerView, long duration, boolean removesFromViewOnPush) {
        super(duration, removesFromViewOnPush);
        int[] fromLocation = new int[2];
        fromView.getLocationInWindow(fromLocation);
        int[] containerLocation = new int[2];
        containerView.getLocationInWindow(containerLocation);
        int relativeLeft = fromLocation[0] - containerLocation[0];
        int relativeTop = fromLocation[1] - containerLocation[1];
        this.mCx = fromView.getWidth() / 2 + relativeLeft;
        this.mCy = fromView.getHeight() / 2 + relativeTop;
    }

    public CircularRevealChangeHandler(int cx, int cy) {
        this(cx, cy, -1L, true);
    }

    public CircularRevealChangeHandler(int cx, int cy, long duration) {
        this(cx, cy, duration, true);
    }

    public CircularRevealChangeHandler(int cx, int cy, boolean removesFromViewOnPush) {
        this(cx, cy, -1L, removesFromViewOnPush);
    }

    public CircularRevealChangeHandler(int cx, int cy, long duration, boolean removesFromViewOnPush) {
        super(duration, removesFromViewOnPush);
        this.mCx = cx;
        this.mCy = cy;
    }

    @Override
    protected Animator getAnimator(@NonNull ViewGroup container, View from, View to, boolean isPush, boolean toAddedToContainer) {
        float radius = (float)Math.hypot(this.mCx, this.mCy);
        Animator animator = null;
        if (isPush && to != null) {
            animator = ViewAnimationUtils.createCircularReveal((View)to, (int)this.mCx, (int)this.mCy, (float)0.0f, (float)radius);
        } else if (!isPush && from != null) {
            animator = ViewAnimationUtils.createCircularReveal((View)from, (int)this.mCx, (int)this.mCy, (float)radius, (float)0.0f);
        }
        return animator;
    }

    @Override
    protected void resetFromView(@NonNull View from) {
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        bundle.putInt(KEY_CX, this.mCx);
        bundle.putInt(KEY_CY, this.mCy);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.mCx = bundle.getInt(KEY_CX);
        this.mCy = bundle.getInt(KEY_CY);
    }
}

