/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.mydailyjava.weaklockfree;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class WeakConcurrentMap<K, V>
extends ReferenceQueue<K>
implements Runnable,
Iterable<Map.Entry<K, V>> {
    private static final ThreadLocal<LatentKey<?>> LATENT_KEY_CACHE = new ThreadLocal<LatentKey<?>>(){

        @Override
        protected LatentKey<?> initialValue() {
            return new LatentKey();
        }
    };
    private static final AtomicLong ID = new AtomicLong();
    final ConcurrentMap<WeakKey<K>, V> target;
    private final Thread thread;
    private final boolean reuseKeys;

    public WeakConcurrentMap(boolean cleanerThread) {
        this(cleanerThread, WeakConcurrentMap.isPersistentClassLoader(LatentKey.class.getClassLoader()));
    }

    private static boolean isPersistentClassLoader(ClassLoader classLoader) {
        try {
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public WeakConcurrentMap(boolean cleanerThread, boolean reuseKeys) {
        this.reuseKeys = reuseKeys;
        this.target = new ConcurrentHashMap<WeakKey<K>, V>();
        if (cleanerThread) {
            this.thread = new Thread(this);
            this.thread.setName("weak-ref-cleaner-" + ID.getAndIncrement());
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V previousValue;
        Object value;
        if (key == null) {
            throw new NullPointerException();
        }
        LatentKey<K> latentKey = this.getKey(key);
        try {
            value = this.target.get(latentKey);
        }
        finally {
            latentKey.reset();
        }
        if (value == null && (value = this.defaultValue(key)) != null && (previousValue = this.target.putIfAbsent(new WeakKey<K>(key, this), value)) != null) {
            value = previousValue;
        }
        return value;
    }

    private LatentKey<K> getKey(K key) {
        LatentKey<Object> latentKey = this.reuseKeys ? LATENT_KEY_CACHE.get() : new LatentKey();
        return latentKey.withValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfPresent(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        LatentKey<K> latentKey = this.getKey(key);
        try {
            Object v = this.target.get(latentKey);
            return v;
        }
        finally {
            latentKey.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        LatentKey<K> latentKey = this.getKey(key);
        try {
            boolean bl = this.target.containsKey(latentKey);
            return bl;
        }
        finally {
            latentKey.reset();
        }
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.put(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        Object previous;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        LatentKey<K> latentKey = this.getKey(key);
        try {
            previous = this.target.get(latentKey);
        }
        finally {
            latentKey.reset();
        }
        return previous == null ? this.target.putIfAbsent(new WeakKey<K>(key, this), value) : previous;
    }

    public V putIfProbablyAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.putIfAbsent(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        LatentKey<K> latentKey = this.getKey(key);
        try {
            Object v = this.target.remove(latentKey);
            return v;
        }
        finally {
            latentKey.reset();
        }
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K key) {
        return null;
    }

    public Thread getCleanerThread() {
        return this.thread;
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.target.remove(reference);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.target.remove(this.remove());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    private class SimpleEntry
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<WeakKey<K>, V> entry;

        private SimpleEntry(K key, Map.Entry<WeakKey<K>, V> entry) {
            this.key = key;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(value);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<WeakKey<K>, V>> iterator;
        private Map.Entry<WeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<WeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = this.iterator.next();
                this.nextKey = this.nextEntry.getKey().get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WithInlinedExpunction<K, V>
    extends WeakConcurrentMap<K, V> {
        public WithInlinedExpunction() {
            super(false);
        }

        @Override
        public V get(K key) {
            this.expungeStaleEntries();
            return super.get(key);
        }

        @Override
        public boolean containsKey(K key) {
            this.expungeStaleEntries();
            return super.containsKey(key);
        }

        @Override
        public V put(K key, V value) {
            this.expungeStaleEntries();
            return super.put(key, value);
        }

        @Override
        public V remove(K key) {
            this.expungeStaleEntries();
            return super.remove(key);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            this.expungeStaleEntries();
            return super.iterator();
        }

        @Override
        public int approximateSize() {
            this.expungeStaleEntries();
            return super.approximateSize();
        }
    }

    private static class LatentKey<T> {
        T key;
        private int hashCode;

        private LatentKey() {
        }

        LatentKey<T> withValue(T key) {
            this.key = key;
            this.hashCode = System.identityHashCode(key);
            return this;
        }

        void reset() {
            this.key = null;
            this.hashCode = 0;
        }

        public boolean equals(Object other) {
            if (other instanceof LatentKey) {
                return ((LatentKey)other).key == this.key;
            }
            return ((WeakKey)other).get() == this.key;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class WeakKey<T>
    extends WeakReference<T> {
        private final int hashCode;

        WeakKey(T key, ReferenceQueue<? super T> queue) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other instanceof LatentKey) {
                return ((LatentKey)other).key == this.get();
            }
            return ((WeakKey)other).get() == this.get();
        }
    }
}

