/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class InstantTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<Instant> {
    public static final TypeConverter<?> INSTANCE = new InstantTypeConverter();
    private static final long serialVersionUID = 1L;

    private InstantTypeConverter() {
        super("literal_instant");
    }

    @Override
    public Instant convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            Calendar result = Calendar.getInstance();
            result.setTime(date);
            return result.toInstant();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).toInstant();
        }
        if (value instanceof String) {
            return Timestamp.valueOf((String)value).toInstant();
        }
        throw InstantTypeConverter.unknownConversion(value, Instant.class);
    }

    @Override
    public String toString(Instant value) {
        ZonedDateTime zonedDateTime = value.atZone(ZoneId.systemDefault());
        return TypeUtils.jdbcTimestamp(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano());
    }

    @Override
    public void appendTo(Instant value, StringBuilder stringBuilder) {
        ZonedDateTime zonedDateTime = value.atZone(ZoneId.systemDefault());
        TypeUtils.appendJdbcTimestamp(stringBuilder, zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano());
    }
}

