/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.CharSequenceUtils;
import com.blazebit.persistence.parser.SubSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class XmlParser {
    private XmlParser() {
    }

    public static List<Object[]> parse(CharSequence xml, String ... fields) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder sb = new StringBuilder();
        if (xml != null && xml.length() != 0) {
            int i;
            HashMap<String, Integer> fieldMap = new HashMap<String, Integer>(fields.length);
            for (i = 0; i < fields.length; ++i) {
                fieldMap.put(fields[i], i);
            }
            for (i = 0; i < xml.length(); ++i) {
                Object[] object = new Object[fields.length];
                boolean key = true;
                boolean escape = false;
                int fieldIndex = -1;
                block11: for (i = CharSequenceUtils.indexOf(xml, "<e>", i) + 3; i < xml.length(); ++i) {
                    char c = xml.charAt(i);
                    switch (c) {
                        case '<': {
                            String tag;
                            int endIndex = CharSequenceUtils.indexOf(xml, '>', i);
                            if (key) {
                                if (xml.charAt(i + 1) == '/') {
                                    i = endIndex;
                                    break block11;
                                }
                                tag = xml.subSequence(i + 1, endIndex).toString();
                                fieldIndex = (Integer)fieldMap.get(tag);
                                i = endIndex;
                                key = false;
                            } else {
                                tag = xml.subSequence(i + 2, endIndex).toString();
                                if (xml.charAt(i + 1) != '/' || !tag.equals(fields[fieldIndex])) {
                                    throw new IllegalStateException("Unexpected tag at position: " + i);
                                }
                                object[fieldIndex] = escape ? sb.toString() : new SubSequence(xml, i - sb.length(), i);
                                key = true;
                                fieldIndex = -1;
                                i = endIndex;
                            }
                            sb.setLength(0);
                            continue block11;
                        }
                        case '&': {
                            escape = true;
                            switch (xml.charAt(i + 1)) {
                                case 'a': {
                                    sb.append('&');
                                    i += 4;
                                    continue block11;
                                }
                                case 'l': {
                                    sb.append('<');
                                    i += 3;
                                    continue block11;
                                }
                                case 'g': {
                                    sb.append('>');
                                    i += 3;
                                    continue block11;
                                }
                            }
                            throw new IllegalStateException("Unexpected escape sequence at position: " + i);
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                list.add(object);
            }
        }
        return list;
    }
}

