/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StaticInputStream {
    private InputStream inputStream;
    private int size;
    private ByteBuf byteBuf;

    public StaticInputStream(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.byteBuf = Unpooled.buffer();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            this.size += len;
            baos.write(buffer, 0, len);
        }
        baos.flush();
        this.inputStream = new ByteArrayInputStream(baos.toByteArray());
        this.byteBuf.writeBytes(this.inputStream, this.size);
    }

    public int size() {
        return this.size;
    }

    public ByteBuf asByteBuf() {
        return this.byteBuf;
    }
}

