/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.kit.DateKit;
import com.blade.server.netty.HttpServerHandler;
import com.blade.server.netty.MergeRequestHandler;
import com.blade.server.netty.WebSocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.ssl.SslContext;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerInitializer.class);
    private final HttpServerHandler httpServerHandler;
    private final SslContext sslCtx;
    private final Blade blade;
    private final boolean isWebSocket;
    private final boolean useGZIP;
    public static volatile String date = DateKit.gmtDate(LocalDateTime.now());

    public HttpServerInitializer(SslContext sslCtx, Blade blade, ScheduledExecutorService service) {
        this.sslCtx = sslCtx;
        this.blade = blade;
        this.useGZIP = blade.environment().getBoolean("http.gzip.enable", false);
        this.isWebSocket = blade.routeMatcher().getWebSockets().size() > 0;
        this.httpServerHandler = new HttpServerHandler();
        service.scheduleWithFixedDelay(() -> {
            date = DateKit.gmtDate(LocalDateTime.now());
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        try {
            if (this.sslCtx != null) {
                pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
            if (this.useGZIP) {
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
            }
            if (this.isWebSocket) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketHandler(this.blade)});
            }
            pipeline.addLast(new ChannelHandler[]{new MergeRequestHandler()});
            pipeline.addLast(new ChannelHandler[]{this.httpServerHandler});
        }
        catch (Exception e) {
            log.error("Add channel pipeline error", (Throwable)e);
        }
    }
}

