/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.xss;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class XssOption {
    private Set<String> urlExclusions;

    public XssOption exclusion(String ... urls) {
        if (urls == null) {
            throw new NullPointerException("urls");
        }
        this.urlExclusions.addAll(Arrays.asList(urls));
        return this;
    }

    public boolean isExclusion(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        for (String excludeURL : this.urlExclusions) {
            if (!url.equals(excludeURL)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> $default$urlExclusions() {
        return new HashSet<String>();
    }

    public static XssOptionBuilder builder() {
        return new XssOptionBuilder();
    }

    public Set<String> getUrlExclusions() {
        return this.urlExclusions;
    }

    public void setUrlExclusions(Set<String> urlExclusions) {
        this.urlExclusions = urlExclusions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XssOption)) {
            return false;
        }
        XssOption other = (XssOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$urlExclusions = this.getUrlExclusions();
        Set<String> other$urlExclusions = other.getUrlExclusions();
        return !(this$urlExclusions == null ? other$urlExclusions != null : !((Object)this$urlExclusions).equals(other$urlExclusions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XssOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $urlExclusions = this.getUrlExclusions();
        result = result * 59 + ($urlExclusions == null ? 43 : ((Object)$urlExclusions).hashCode());
        return result;
    }

    public String toString() {
        return "XssOption(urlExclusions=" + this.getUrlExclusions() + ")";
    }

    public XssOption(Set<String> urlExclusions) {
        this.urlExclusions = urlExclusions;
    }

    public XssOption() {
    }

    public static class XssOptionBuilder {
        private boolean urlExclusions$set;
        private Set<String> urlExclusions;

        XssOptionBuilder() {
        }

        public XssOptionBuilder urlExclusions(Set<String> urlExclusions) {
            this.urlExclusions = urlExclusions;
            this.urlExclusions$set = true;
            return this;
        }

        public XssOption build() {
            Set urlExclusions = this.urlExclusions;
            if (!this.urlExclusions$set) {
                urlExclusions = XssOption.$default$urlExclusions();
            }
            return new XssOption(urlExclusions);
        }

        public String toString() {
            return "XssOption.XssOptionBuilder(urlExclusions=" + this.urlExclusions + ")";
        }
    }
}

