/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.cors;

import java.util.List;

public class CorsConfiger {
    public static final String ALL = "*";
    public static final String DEFAULT_ALLOWED_HEADERS = "Origin, X-Requested-With, Content-Type, Accept, Connection, User-Agent, Cookie, Cache-Control, token";
    public static final String DEFAULT_ALLOWED_METHODS = "GET, OPTIONS, HEAD, PUT, POST, DELETE";
    public static final String DEFAULT_ALLOW_CREDENTIALS = "true";
    public static final Long DEFAULT_MAX_AGE = 1800L;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private Long maxAge;
    private Boolean allowCredentials;

    public static CorsConfigerBuilder builder() {
        return new CorsConfigerBuilder();
    }

    public CorsConfiger(List<String> allowedMethods, List<String> allowedHeaders, Long maxAge, Boolean allowCredentials) {
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.maxAge = maxAge;
        this.allowCredentials = allowCredentials;
    }

    public CorsConfiger() {
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsConfiger)) {
            return false;
        }
        CorsConfiger other = (CorsConfiger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$allowedMethods = this.getAllowedMethods();
        List<String> other$allowedMethods = other.getAllowedMethods();
        if (this$allowedMethods == null ? other$allowedMethods != null : !((Object)this$allowedMethods).equals(other$allowedMethods)) {
            return false;
        }
        List<String> this$allowedHeaders = this.getAllowedHeaders();
        List<String> other$allowedHeaders = other.getAllowedHeaders();
        if (this$allowedHeaders == null ? other$allowedHeaders != null : !((Object)this$allowedHeaders).equals(other$allowedHeaders)) {
            return false;
        }
        Long this$maxAge = this.getMaxAge();
        Long other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        return !(this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CorsConfiger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $allowedMethods = this.getAllowedMethods();
        result = result * 59 + ($allowedMethods == null ? 43 : ((Object)$allowedMethods).hashCode());
        List<String> $allowedHeaders = this.getAllowedHeaders();
        result = result * 59 + ($allowedHeaders == null ? 43 : ((Object)$allowedHeaders).hashCode());
        Long $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        return result;
    }

    public String toString() {
        return "CorsConfiger(allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", maxAge=" + this.getMaxAge() + ", allowCredentials=" + this.getAllowCredentials() + ")";
    }

    public static class CorsConfigerBuilder {
        private List<String> allowedMethods;
        private List<String> allowedHeaders;
        private Long maxAge;
        private Boolean allowCredentials;

        CorsConfigerBuilder() {
        }

        public CorsConfigerBuilder allowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public CorsConfigerBuilder allowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public CorsConfigerBuilder maxAge(Long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CorsConfigerBuilder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public CorsConfiger build() {
            return new CorsConfiger(this.allowedMethods, this.allowedHeaders, this.maxAge, this.allowCredentials);
        }

        public String toString() {
            return "CorsConfiger.CorsConfigerBuilder(allowedMethods=" + this.allowedMethods + ", allowedHeaders=" + this.allowedHeaders + ", maxAge=" + this.maxAge + ", allowCredentials=" + this.allowCredentials + ")";
        }
    }
}

