/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route.mapping;

import com.blade.kit.BladeKit;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.route.PathRegexBuilder;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.mapping.FastRouteMappingInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMapping {
    private static final Logger log = LoggerFactory.getLogger(RegexMapping.class);
    private Map<HttpMethod, Map<Integer, FastRouteMappingInfo>> regexRoutes = new HashMap<HttpMethod, Map<Integer, FastRouteMappingInfo>>();
    private Map<HttpMethod, Pattern> regexRoutePatterns = new HashMap<HttpMethod, Pattern>();
    private Map<HttpMethod, Integer> indexes = new HashMap<HttpMethod, Integer>();
    private Map<HttpMethod, StringBuilder> patternBuilders = new HashMap<HttpMethod, StringBuilder>();

    public void addRoute(String path, HttpMethod httpMethod, Route route, List<String> uriVariableNames) {
        if (this.regexRoutes.get((Object)httpMethod) == null) {
            this.regexRoutes.put(httpMethod, new HashMap());
            this.patternBuilders.put(httpMethod, new StringBuilder("^"));
            this.indexes.put(httpMethod, 1);
        }
        int i = this.indexes.get((Object)httpMethod);
        this.regexRoutes.get((Object)httpMethod).put(i, new FastRouteMappingInfo(route, uriVariableNames));
        this.indexes.put(httpMethod, i + uriVariableNames.size() + 1);
        this.patternBuilders.get((Object)httpMethod).append(new PathRegexBuilder().parsePath(path));
    }

    public FastRouteMappingInfo findMappingInfo(HttpMethod httpMethod, int index) {
        return this.regexRoutes.get((Object)httpMethod).get(index);
    }

    public void register() {
        this.patternBuilders.keySet().stream().filter(this::notIsWebHook).forEach(this::registerRoutePatterns);
    }

    private void registerRoutePatterns(HttpMethod httpMethod) {
        StringBuilder patternBuilder = this.patternBuilders.get((Object)httpMethod);
        if (patternBuilder.length() > 1) {
            patternBuilder.setCharAt(patternBuilder.length() - 1, '$');
        }
        log.debug("Fast Route Method: {}, regex: {}", (Object)httpMethod, (Object)patternBuilder);
        this.regexRoutePatterns.put(httpMethod, Pattern.compile(patternBuilder.toString()));
    }

    public Pattern findPattern(HttpMethod requestMethod) {
        return this.regexRoutePatterns.get((Object)requestMethod);
    }

    private boolean notIsWebHook(HttpMethod httpMethod) {
        return !BladeKit.isWebHook(httpMethod);
    }

    public void clear() {
        this.regexRoutes.clear();
        this.regexRoutePatterns.clear();
        this.indexes.clear();
        this.patternBuilders.clear();
    }
}

