/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.Environment;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Inject;
import com.blade.ioc.annotation.InjectWith;
import com.blade.ioc.annotation.Value;
import com.blade.ioc.bean.BeanDefine;
import com.blade.ioc.bean.ClassDefine;
import com.blade.ioc.bean.FieldInjector;
import com.blade.ioc.bean.ValueInjector;
import com.blade.kit.ReflectKit;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IocKit {
    private static List<FieldInjector> getInjectFields(Ioc ioc, ClassDefine classDefine) {
        ArrayList<FieldInjector> injectors = new ArrayList<FieldInjector>();
        for (Field field : classDefine.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectWith.class) && null == field.getAnnotation(Inject.class)) continue;
            injectors.add(new FieldInjector(ioc, field));
        }
        if (injectors.size() == 0) {
            return new ArrayList<FieldInjector>();
        }
        return injectors;
    }

    private static List<ValueInjector> getValueInjectFields(Environment environment, ClassDefine classDefine) {
        ArrayList<ValueInjector> valueInjectors = new ArrayList<ValueInjector>(8);
        if (null != classDefine.getType().getAnnotation(Value.class)) {
            String suffix = classDefine.getType().getAnnotation(Value.class).name();
            Arrays.stream(classDefine.getDeclaredFields()).forEach(field -> valueInjectors.add(new ValueInjector(environment, (Field)field, suffix + "." + field.getName())));
        } else {
            Arrays.stream(classDefine.getDeclaredFields()).filter(field -> null != field.getAnnotation(Value.class)).map(field -> new ValueInjector(environment, (Field)field, field.getAnnotation(Value.class).name())).forEach(valueInjectors::add);
        }
        return valueInjectors;
    }

    public static void injection(Ioc ioc, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<FieldInjector> fieldInjectors = IocKit.getInjectFields(ioc, classDefine);
        Object bean = beanDefine.getBean();
        fieldInjectors.forEach(fieldInjector -> {
            Object fieldInstance = ReflectKit.newInstance(fieldInjector.getType());
            if (fieldInjector.hasInjectFields()) {
                IocKit.injection(ioc, new BeanDefine(fieldInstance));
            }
            fieldInjector.injection(bean, fieldInstance);
        });
    }

    public static void initInjection(Ioc ioc, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<FieldInjector> fieldInjectors = IocKit.getInjectFields(ioc, classDefine);
        Object bean = beanDefine.getBean();
        AtomicBoolean hasPrototypeField = new AtomicBoolean(false);
        fieldInjectors.forEach(fieldInjector -> {
            if (fieldInjector.isSingleton()) {
                fieldInjector.injection(bean);
            } else {
                hasPrototypeField.set(true);
            }
        });
        beanDefine.setFieldHasPrototype(hasPrototypeField.get());
    }

    public static void injectionValue(Environment environment, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<ValueInjector> valueFields = IocKit.getValueInjectFields(environment, classDefine);
        Object bean = beanDefine.getBean();
        valueFields.forEach(fieldInjector -> fieldInjector.injection(bean));
    }

    public static boolean isSingleton(Class<?> type) {
        return true;
    }

    private IocKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

