/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class DateKit {
    public static final DateTimeFormatter GMT_FMT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    public static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    private static final Map<String, String> PRETTY_TIME_I18N = new HashMap<String, String>();

    public static int nowUnix() {
        return (int)Instant.now().getEpochSecond();
    }

    public static String toString(long unixTime, String pattern) {
        return Instant.ofEpochSecond(unixTime).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(Date date, String pattern) {
        Instant instant = new Date(date.getTime()).toInstant();
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(LocalDate date, String pattern) {
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(LocalDateTime date, String pattern) {
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(LocalDateTime time) {
        return DateKit.toString(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static int toUnix(String time, String pattern) {
        LocalDateTime formatted = LocalDateTime.parse(time, DateTimeFormatter.ofPattern(pattern));
        return (int)formatted.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static int toUnix(String time) {
        return DateKit.toUnix(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static int toUnix(Date date) {
        return (int)date.toInstant().getEpochSecond();
    }

    public static Date toDate(String time, String pattern) {
        LocalDate formatted = LocalDate.parse(time, DateTimeFormatter.ofPattern(pattern));
        return Date.from(Instant.from(formatted.atStartOfDay(ZoneId.systemDefault())));
    }

    public static Date toDateTime(String time, String pattern) {
        LocalDateTime formatted = LocalDateTime.parse(time, DateTimeFormatter.ofPattern(pattern));
        return Date.from(formatted.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(String time, String pattern) {
        return LocalDate.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime toLocalDateTime(String time, String pattern) {
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date toDate(long unixTime) {
        return Date.from(Instant.ofEpochSecond(unixTime));
    }

    public static String gmtDate() {
        return GMT_FMT.format(LocalDateTime.now().atZone(GMT_ZONE_ID));
    }

    public static String gmtDate(LocalDateTime localDateTime) {
        return GMT_FMT.format(localDateTime.atZone(GMT_ZONE_ID));
    }

    public static String gmtDate(Date date) {
        return GMT_FMT.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).atZone(GMT_ZONE_ID));
    }

    public static String prettyTime(LocalDateTime date, Locale locale) {
        if (date == null) {
            return null;
        }
        String keyPrefix = locale.getLanguage().equals("zh") ? "zh" : "us";
        long diff = Duration.between(date, LocalDateTime.now()).toMillis() / 1000L;
        if (diff >= 31536000L) {
            int amount = (int)(diff / 31536000L);
            if (amount == 1) {
                return PRETTY_TIME_I18N.get(keyPrefix + "_LAST_YEAR");
            }
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_YEARS");
        }
        if (diff >= 2592000L) {
            int amount = (int)(diff / 2592000L);
            if (amount == 1) {
                return PRETTY_TIME_I18N.get(keyPrefix + "_LAST_MONTH");
            }
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_MONTHS");
        }
        if (diff >= 604800L) {
            int amount = (int)(diff / 604800L);
            if (amount == 1) {
                return PRETTY_TIME_I18N.get(keyPrefix + "_LAST_WEEK");
            }
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_WEEKS");
        }
        if (diff >= 86400L) {
            int amount = (int)(diff / 86400L);
            if (amount == 1) {
                return PRETTY_TIME_I18N.get(keyPrefix + "_YESTERDAY");
            }
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_DAYS");
        }
        if (diff >= 3600L) {
            int amount = (int)(diff / 3600L);
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_HOURS");
        }
        if (diff >= 60L) {
            int amount = (int)(diff / 60L);
            return amount + PRETTY_TIME_I18N.get(keyPrefix + "_MINUTES");
        }
        int amount = (int)diff;
        if (amount < 6) {
            return PRETTY_TIME_I18N.get(keyPrefix + "_JUST_NOW");
        }
        return amount + PRETTY_TIME_I18N.get(keyPrefix + "_SECONDS");
    }

    public static String prettyTime(LocalDateTime date) {
        return DateKit.prettyTime(date, Locale.getDefault());
    }

    private DateKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PRETTY_TIME_I18N.put("zh_YEARS", "\u5e74\u524d");
        PRETTY_TIME_I18N.put("zh_MONTHS", "\u4e2a\u6708\u524d");
        PRETTY_TIME_I18N.put("zh_WEEKS", "\u5468\u524d");
        PRETTY_TIME_I18N.put("zh_DAYS", "\u5929\u524d");
        PRETTY_TIME_I18N.put("zh_HOURS", "\u5c0f\u65f6\u524d");
        PRETTY_TIME_I18N.put("zh_MINUTES", "\u5206\u949f\u524d");
        PRETTY_TIME_I18N.put("zh_SECONDS", "\u79d2\u524d");
        PRETTY_TIME_I18N.put("zh_JUST_NOW", "\u521a\u521a");
        PRETTY_TIME_I18N.put("zh_YESTERDAY", "\u6628\u5929");
        PRETTY_TIME_I18N.put("zh_LAST_WEEK", "\u4e0a\u5468");
        PRETTY_TIME_I18N.put("zh_LAST_MONTH", "\u4e0a\u4e2a\u6708");
        PRETTY_TIME_I18N.put("zh_LAST_YEAR", "\u53bb\u5e74");
        PRETTY_TIME_I18N.put("us_YEARS", "years ago");
        PRETTY_TIME_I18N.put("us_MONTHS", "months ago");
        PRETTY_TIME_I18N.put("us_DAYS", "days ago");
        PRETTY_TIME_I18N.put("us_HOURS", "hours ago");
        PRETTY_TIME_I18N.put("us_MINUTES", "minutes ago");
        PRETTY_TIME_I18N.put("us_SECONDS", "seconds ago");
        PRETTY_TIME_I18N.put("us_JUST_NOW", "Just now");
        PRETTY_TIME_I18N.put("us_YESTERDAY", "Yesterday");
        PRETTY_TIME_I18N.put("us_LAST_WEEK", "Last week");
        PRETTY_TIME_I18N.put("us_LAST_MONTH", "Last month");
        PRETTY_TIME_I18N.put("us_LAST_YEAR", "Last year");
    }
}

