/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.format;

import android.content.Context;
import java.util.Locale;

public class Formatter {
    public static String formatFileSize(Context context, long roundedBytes) {
        return Formatter.formatFileSize(context, roundedBytes, false, Locale.US);
    }

    public static String formatFileSize(Context context, long roundedBytes, Locale locale) {
        return Formatter.formatFileSize(context, roundedBytes, false, locale);
    }

    private static String formatFileSize(Context context, long roundedBytes, boolean shorter, Locale locale) {
        if (context == null) {
            return "";
        }
        float result = roundedBytes;
        String suffix = "B";
        if (result > 900.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        String value = result < 1.0f ? String.format(locale, "%.2f", Float.valueOf(result)) : (result < 10.0f ? (shorter ? String.format(locale, "%.1f", Float.valueOf(result)) : String.format(locale, "%.2f", Float.valueOf(result))) : (result < 100.0f ? (shorter ? String.format(locale, "%.0f", Float.valueOf(result)) : String.format(locale, "%.2f", Float.valueOf(result))) : String.format(locale, "%.0f", Float.valueOf(result))));
        return String.format("%s%s", value, suffix);
    }
}

