/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.file.action;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.time.DateUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\u001e\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ&\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bJ\u0018\u0010'\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\bJ\u001e\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bJ\u001e\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b\u00a8\u0006*"}, d2={"Lcom/bihe0832/android/lib/file/action/FileAction;", "", "()V", "copyAssetsFileToPath", "", "context", "Landroid/content/Context;", "fromFileName", "", "targetPath", "copyAssetsFolderToFolder", "fromAssetPath", "targetFolder", "copyDirectory", "", "src", "Ljava/io/File;", "dest", "isMove", "copyFile", "source", "srcFile", "dstFile", "copyStream", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "deleteDirectory", "dir", "deleteFile", "filePath", "deleteOld", "duration", "", "deleteOldAsync", "fileAction", "action", "fileType", "isAssetsExists", "openFile", "sendFile", "LibFile_release"})
public final class FileAction {
    public static final FileAction INSTANCE;

    public final boolean openFile(@NotNull Context context, @NotNull String filePath, @NotNull String fileType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        return this.fileAction(context, "android.intent.action.VIEW", filePath, fileType);
    }

    public final boolean sendFile(@NotNull Context context, @NotNull String filePath, @NotNull String fileType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        return this.fileAction(context, "android.intent.action.SEND", filePath, fileType);
    }

    public final boolean fileAction(@NotNull Context context, @NotNull String action, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.fileAction(context, action, filePath, "*/*");
    }

    public final boolean fileAction(@NotNull Context context, @NotNull String action, @NotNull String filePath, @NotNull String fileType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        try {
            File sourceFile;
            ZLog.d((String)("fileAction sourceFile:" + filePath));
            File targetFile = sourceFile = new File(filePath);
            if (BuildUtils.INSTANCE.getSDK_INT() >= 24 && sourceFile.isFile() && sourceFile.exists()) {
                Uri uri;
                try {
                    uri = ZixieFileProvider.getZixieFileProvider(context, new File(filePath));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    uri = null;
                }
                Uri fileProvider = uri;
                if (fileProvider == null) {
                    ZLog.e((String)"fileAction targetFile dont has zixie FileProvider");
                    targetFile = new File(ZixieFileProvider.getZixieFilePath(context) + FileUtils.INSTANCE.getFileName(filePath));
                    this.copyFile(sourceFile, targetFile);
                }
            }
            ZLog.d((String)("fileAction targetFile:" + targetFile.getAbsolutePath()));
            Intent intent = new Intent(action);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setFlags(0x10000000);
            $this$apply.addCategory("android.intent.category.DEFAULT");
            ZixieFileProvider.setFileUriForIntent(context, $this$apply, targetFile, fileType);
            bl = false;
            bl2 = false;
            Intent it = intent;
            boolean bl4 = false;
            context.startActivity(it);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final void deleteOldAsync(@NotNull File dir, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        ThreadManager.getInstance().start(new Runnable(dir, duration){
            final /* synthetic */ File $dir;
            final /* synthetic */ long $duration;

            public final void run() {
                FileAction.INSTANCE.deleteOld(this.$dir, this.$duration);
            }
            {
                this.$dir = file;
                this.$duration = l;
            }
        });
    }

    public final void deleteOld(@NotNull File dir, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        File[] fileArray = dir.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"dir.listFiles()");
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        File[] fileArray2 = $this$forEach$iv;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            File element$iv;
            File tempFile = element$iv = fileArray2[i];
            boolean bl2 = false;
            long lastModify = tempFile.lastModified();
            ZLog.w((String)"File", (String)("File " + tempFile + " Date is " + DateUtil.getDateEN((long)lastModify)));
            if (!tempFile.exists() || System.currentTimeMillis() - lastModify <= duration) continue;
            File file = tempFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
            if (file.isDirectory()) {
                bl = INSTANCE.deleteDirectory(tempFile);
            } else {
                String string2 = tempFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempFile.absolutePath");
                bl = INSTANCE.deleteFile(string2);
            }
            boolean result = bl;
            ZLog.w((String)"File", (String)("File tempFile has delete: " + result));
        }
    }

    public final boolean deleteDirectory(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        try {
            if (!dir.exists()) {
                return true;
            }
            if (dir.isDirectory()) {
                String[] childrens;
                String[] stringArray = dir.list();
                Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"dir.list()");
                for (String child : childrens = stringArray) {
                    boolean success = this.deleteDirectory(new File(dir, child));
                    if (success) continue;
                    return false;
                }
                return dir.delete();
            }
            String string2 = dir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dir.absolutePath");
            return this.deleteFile(string2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final boolean deleteFile(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            return new File(filePath).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean copyFile(@NotNull File source, @NotNull File dest) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean e2 = false;
            return e2;
        }
        finally {
            try {
                FileChannel fileChannel = inputChannel;
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                FileChannel fileChannel = outputChannel;
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final boolean copyFile(@NotNull File srcFile, @NotNull File dstFile, boolean isMove) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)dstFile, (String)"dstFile");
        return isMove ? srcFile.renameTo(dstFile) : this.copyFile(srcFile, dstFile);
    }

    public final void copyDirectory(@NotNull File src, @NotNull File dest, boolean isMove) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        try {
            if (src.isDirectory()) {
                String[] files;
                if (!dest.exists()) {
                    dest.mkdir();
                }
                for (String file : files = src.list()) {
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    this.copyDirectory(srcFile, destFile, isMove);
                }
            } else {
                this.copyFile(src, dest, isMove);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void copyStream(InputStream input, OutputStream output) {
        byte[] buff = new byte[1024];
        int read = 0;
        do {
            if ((read = input.read(buff)) <= 0) continue;
            output.write(buff, 0, read);
        } while (read > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean copyAssetsFileToPath(@Nullable Context context, @NotNull String fromFileName, @NotNull String targetPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromFileName, (String)"fromFileName");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        if (context == null) {
            ZLog.e((String)"copyAssetsToSdcard context is null");
            return false;
        }
        try {
            File file = new File(targetPath).getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(targetPath).parentFile");
            String string2 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File(targetPath).parentFile.absolutePath");
            FileUtils.INSTANCE.checkAndCreateFolder(string2);
            FileUtils.INSTANCE.deleteFile(targetPath);
            Closeable closeable = context.getAssets().open(fromFileName);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new FileOutputStream(targetPath);
                boolean bl3 = false;
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl4 = false;
                    InputStream inputStream = input;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
                    INSTANCE.copyStream(inputStream, output);
                    input.close();
                    output.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.e((String)("copyAssets2Sdcard exception:" + e));
            return false;
        }
    }

    public final boolean copyAssetsFolderToFolder(@Nullable Context context, @NotNull String fromAssetPath, @NotNull String targetFolder) {
        Intrinsics.checkParameterIsNotNull((Object)fromAssetPath, (String)"fromAssetPath");
        Intrinsics.checkParameterIsNotNull((Object)targetFolder, (String)"targetFolder");
        if (context == null) {
            ZLog.e((String)"copyAssetsFolder context is null");
            return false;
        }
        try {
            String source = TextUtils.isEmpty((CharSequence)fromAssetPath) ? fromAssetPath : fromAssetPath + File.separator;
            String target = FileUtils.INSTANCE.getFolderPathWithSeparator(targetFolder);
            boolean res = true;
            String[] stringArray = context.getAssets().list(fromAssetPath);
            if (stringArray != null) {
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                String[] stringArray2 = $this$forEach$iv;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    String[] dataArray;
                    String element$iv;
                    String file = element$iv = stringArray2[i];
                    boolean bl2 = false;
                    String[] stringArray3 = context.getAssets().list(file);
                    if (stringArray3 == null) {
                        stringArray3 = new String[]{};
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringArray3, (String)"context.assets.list(file) ?: emptyArray()");
                    String[] stringArray4 = dataArray = stringArray3;
                    boolean bl3 = false;
                    String[] stringArray5 = stringArray4;
                    boolean bl4 = false;
                    boolean bl5 = bl = !(stringArray5.length == 0);
                    res = bl ? res && INSTANCE.copyAssetsFolderToFolder(context, source + file, target + file) : (INSTANCE.isAssetsExists(context, source + file) ? res && INSTANCE.copyAssetsFileToPath(context, source + file, target + file) : res);
                }
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.e((String)("copyAssetsFolder exception:" + e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isAssetsExists(@Nullable Context context, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (context == null) {
            ZLog.e((String)"isAssetExists context is null");
            return false;
        }
        inputStream = null;
        try {
            inputStream = context.getAssets().open(filePath);
            if (inputStream != null) {
                var4_4 = true;
                try {
                    inputStream.close();
                    return var4_4;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return var4_4;
            }
            ** try [egrp 2[TRYBLOCK] [1 : 58->62)] { 
        }
        catch (IOException e) {
            e.printStackTrace();
            e = false;
            return e;
            {
                catch (Throwable var4_8) {
                    throw var4_8;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                e = false;
                return e;
            }
        }
        finally {
            try {
                v0 = inputStream;
                if (v0 != null) {
                    v0.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
lbl-1000:
        // 1 sources

        {
            return false;
        }
lbl21:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private FileAction() {
    }

    static {
        FileAction fileAction;
        INSTANCE = fileAction = new FileAction();
    }
}

