/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.accessibility.view;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import com.bihe0832.android.common.accessibility.R;
import com.bihe0832.android.common.accessibility.view.PositionConfig;
import com.bihe0832.android.lib.floatview.BaseIconView;
import com.bihe0832.android.lib.ui.custom.view.background.TextViewWithBackground;
import com.bihe0832.android.lib.utils.ConvertUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0006\u0010\u0013\u001a\u00020\bJ\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0006\u0010\u0015\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\u0006H\u0014J\u0012\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J\u001e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\bJ\u0006\u0010&\u001a\u00020\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/bihe0832/android/common/accessibility/view/PositionIcon;", "Lcom/bihe0832/android/lib/floatview/BaseIconView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCallbackClick", "", "mLocationKey", "", "getMLocationKey", "()Ljava/lang/String;", "setMLocationKey", "(Ljava/lang/String;)V", "mStartLocationX", "", "mStartLocationY", "getDefaultX", "getDefaultY", "getLayoutId", "getLocationKey", "getRootId", "getText", "ignoreStatusBar", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setActived", "", "shouldNotifyClick", "setLocationInfo", "locationKey", "startLocationX", "startLocationY", "setStartLocationX", "location", "setStartLocationY", "setText", "text", "updatePosition", "CommonAccessibility_release"})
public class PositionIcon
extends BaseIconView {
    @NotNull
    private String mLocationKey;
    private int mStartLocationX;
    private int mStartLocationY;
    private boolean mCallbackClick;

    public PositionIcon(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mLocationKey = "";
        this.mCallbackClick = true;
    }

    @NotNull
    protected final String getMLocationKey() {
        return this.mLocationKey;
    }

    protected final void setMLocationKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mLocationKey = string;
    }

    public final void setActived(boolean shouldNotifyClick) {
        this.mCallbackClick = shouldNotifyClick;
    }

    @NotNull
    public final String getLocationKey() {
        return this.mLocationKey;
    }

    public final void setLocationInfo(@NotNull String locationKey, int startLocationX, int startLocationY) {
        Intrinsics.checkNotNullParameter((Object)locationKey, (String)"locationKey");
        this.setStartLocationX(startLocationX);
        this.setStartLocationY(startLocationY);
        this.mLocationKey = locationKey;
    }

    public final void setStartLocationX(int location) {
        this.mStartLocationX = location > 0 ? location : 0;
    }

    public final void setStartLocationY(int location) {
        this.mStartLocationY = location > 0 ? location : 0;
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ((TextViewWithBackground)this.findViewById(R.id.position_text)).setText((CharSequence)text);
    }

    @NotNull
    public final String getText() {
        return ((Object)((TextViewWithBackground)this.findViewById(R.id.position_text)).getText()).toString();
    }

    public int getLayoutId() {
        return R.layout.com_bihe0832_accessibility_position;
    }

    public int getRootId() {
        return R.id.position_layout;
    }

    public int getDefaultX() {
        if (((CharSequence)this.mLocationKey).length() == 0) {
            return this.mStartLocationX;
        }
        List<String> location = PositionConfig.INSTANCE.getPositionList(this.mLocationKey);
        return ConvertUtils.parseInt((String)ConvertUtils.getSafeValueFromList(location, (int)0, (String)""), (int)this.mStartLocationX);
    }

    public int getDefaultY() {
        if (((CharSequence)this.mLocationKey).length() == 0) {
            return this.mStartLocationY;
        }
        List<String> location = PositionConfig.INSTANCE.getPositionList(this.mLocationKey);
        return ConvertUtils.parseInt((String)ConvertUtils.getSafeValueFromList(location, (int)1, (String)""), (int)this.mStartLocationY);
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        if (((CharSequence)this.mLocationKey).length() > 0) {
            MotionEvent motionEvent = event;
            boolean bl = motionEvent != null ? motionEvent.getAction() == 1 : false;
            if (bl) {
                this.updatePosition();
                if (this.mCallbackClick) {
                    this.performClick();
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public final void updatePosition() {
        View $this$isVisible$iv = (View)this;
        boolean $i$f$isVisible = false;
        if ($this$isVisible$iv.getVisibility() == 0) {
            int[] outLocation = new int[2];
            this.getLocationOnScreen(outLocation);
            int centerX = outLocation[0] + (this.getRight() - this.getLeft()) / 2;
            int centerY = outLocation[1] + (this.getBottom() - this.getTop()) / 2;
            PositionConfig.INSTANCE.writePosition(this.mLocationKey, outLocation[0], outLocation[1], centerX, centerY);
        }
    }

    protected boolean ignoreStatusBar() {
        return true;
    }
}

