/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.android.multiselector;

import android.util.SparseArray;
import com.bignerdranch.android.multiselector.SelectableHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class WeakHolderTracker {
    private SparseArray<WeakReference<SelectableHolder>> mHoldersByPosition = new SparseArray();

    WeakHolderTracker() {
    }

    public SelectableHolder getHolder(int position) {
        WeakReference holderRef = (WeakReference)this.mHoldersByPosition.get(position);
        if (holderRef == null) {
            return null;
        }
        SelectableHolder holder = (SelectableHolder)holderRef.get();
        if (holder == null || holder.getAdapterPosition() != position) {
            this.mHoldersByPosition.remove(position);
            return null;
        }
        return holder;
    }

    public void bindHolder(SelectableHolder holder, int position) {
        this.mHoldersByPosition.put(position, new WeakReference<SelectableHolder>(holder));
    }

    public List<SelectableHolder> getTrackedHolders() {
        ArrayList<SelectableHolder> holders = new ArrayList<SelectableHolder>();
        for (int i = 0; i < this.mHoldersByPosition.size(); ++i) {
            int key = this.mHoldersByPosition.keyAt(i);
            SelectableHolder holder = this.getHolder(key);
            if (holder == null) continue;
            holders.add(holder);
        }
        return holders;
    }
}

