/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview.Adapter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.bignerdranch.expandablerecyclerview.Adapter.ExpandableRecyclerAdapterHelper;
import com.bignerdranch.expandablerecyclerview.Model.ParentListItem;
import com.bignerdranch.expandablerecyclerview.Model.ParentWrapper;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ChildViewHolder;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ParentViewHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class ExpandableRecyclerAdapter<PVH extends ParentViewHolder, CVH extends ChildViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ParentViewHolder.ParentListItemExpandCollapseListener {
    private static final String EXPANDED_STATE_MAP = "ExpandableRecyclerAdapter.ExpandedStateMap";
    private static final int TYPE_PARENT = 0;
    private static final int TYPE_CHILD = 1;
    protected List<Object> mItemList;
    private List<? extends ParentListItem> mParentItemList;
    private ExpandCollapseListener mExpandCollapseListener;
    private List<RecyclerView> mAttachedRecyclerViewPool;

    public ExpandableRecyclerAdapter(@NonNull List<? extends ParentListItem> parentItemList) {
        this.mParentItemList = parentItemList;
        this.mItemList = ExpandableRecyclerAdapterHelper.generateParentChildItemList(parentItemList);
        this.mAttachedRecyclerViewPool = new ArrayList<RecyclerView>();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == 0) {
            PVH pvh = this.onCreateParentViewHolder(viewGroup);
            ((ParentViewHolder)((Object)pvh)).setParentListItemExpandCollapseListener(this);
            return pvh;
        }
        if (viewType == 1) {
            return this.onCreateChildViewHolder(viewGroup);
        }
        throw new IllegalStateException("Incorrect ViewType found");
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            ParentViewHolder parentViewHolder = (ParentViewHolder)holder;
            if (parentViewHolder.shouldItemViewClickToggleExpansion()) {
                parentViewHolder.setMainItemClickToExpand();
            }
            ParentWrapper parentWrapper = (ParentWrapper)listItem;
            parentViewHolder.setExpanded(parentWrapper.isExpanded());
            this.onBindParentViewHolder(parentViewHolder, position, parentWrapper.getParentListItem());
        } else {
            if (listItem == null) {
                throw new IllegalStateException("Incorrect ViewHolder found");
            }
            this.onBindChildViewHolder((ChildViewHolder)holder, position, listItem);
        }
    }

    public abstract PVH onCreateParentViewHolder(ViewGroup var1);

    public abstract CVH onCreateChildViewHolder(ViewGroup var1);

    public abstract void onBindParentViewHolder(PVH var1, int var2, ParentListItem var3);

    public abstract void onBindChildViewHolder(CVH var1, int var2, Object var3);

    public int getItemCount() {
        return this.mItemList.size();
    }

    public int getItemViewType(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            return 0;
        }
        if (listItem == null) {
            throw new IllegalStateException("Null object added");
        }
        return 1;
    }

    public List<? extends ParentListItem> getParentItemList() {
        return this.mParentItemList;
    }

    @Override
    public void onParentListItemExpanded(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            this.expandParentListItem((ParentWrapper)listItem, position, true);
        }
    }

    @Override
    public void onParentListItemCollapsed(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            this.collapseParentListItem((ParentWrapper)listItem, position, true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.add(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.remove(recyclerView);
    }

    public void setExpandCollapseListener(ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    public void expandParent(int parentIndex) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentIndex);
        Object listItem = this.getListItem(parentWrapperIndex);
        if (!(listItem instanceof ParentWrapper)) {
            return;
        }
        ParentWrapper parentWrapper = (ParentWrapper)listItem;
        this.expandViews(parentWrapper, parentWrapperIndex);
    }

    public void expandParent(ParentListItem parentListItem) {
        ParentWrapper parentWrapper = this.getParentWrapper(parentListItem);
        int parentWrapperIndex = this.mItemList.indexOf(parentWrapper);
        if (parentWrapperIndex == -1) {
            return;
        }
        this.expandViews(parentWrapper, parentWrapperIndex);
    }

    public void expandAllParents() {
        for (ParentListItem parentListItem : this.mParentItemList) {
            this.expandParent(parentListItem);
        }
    }

    public void collapseParent(int parentIndex) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentIndex);
        Object listItem = this.getListItem(parentWrapperIndex);
        if (!(listItem instanceof ParentWrapper)) {
            return;
        }
        ParentWrapper parentWrapper = (ParentWrapper)listItem;
        this.collapseViews(parentWrapper, parentWrapperIndex);
    }

    public void collapseParent(ParentListItem parentListItem) {
        ParentWrapper parentWrapper = this.getParentWrapper(parentListItem);
        int parentWrapperIndex = this.mItemList.indexOf(parentWrapper);
        if (parentWrapperIndex == -1) {
            return;
        }
        this.collapseViews(parentWrapper, parentWrapperIndex);
    }

    public void collapseAllParents() {
        for (ParentListItem parentListItem : this.mParentItemList) {
            this.collapseParent(parentListItem);
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putSerializable(EXPANDED_STATE_MAP, this.generateExpandedStateMap());
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null || !savedInstanceState.containsKey(EXPANDED_STATE_MAP)) {
            return;
        }
        HashMap expandedStateMap = (HashMap)savedInstanceState.getSerializable(EXPANDED_STATE_MAP);
        int childCount = 0;
        int listItemCount = this.mItemList.size();
        for (int fullCount = 0; fullCount < listItemCount; ++fullCount) {
            Object listItem = this.getListItem(fullCount);
            if (listItem instanceof ParentWrapper) {
                int j;
                int childListItemCount;
                List<?> childItemList;
                ParentWrapper parentWrapper = (ParentWrapper)listItem;
                if (!expandedStateMap.containsKey(fullCount - childCount)) continue;
                parentWrapper.setExpanded((Boolean)expandedStateMap.get(fullCount - childCount));
                if (parentWrapper.isExpanded() && !parentWrapper.isInitiallyExpanded()) {
                    childItemList = parentWrapper.getChildItemList();
                    if (childItemList == null) continue;
                    childListItemCount = childItemList.size();
                    for (j = 0; j < childListItemCount; ++j) {
                        ++childCount;
                        this.mItemList.add(++fullCount, childItemList.get(j));
                    }
                    continue;
                }
                if (parentWrapper.isExpanded() || !parentWrapper.isInitiallyExpanded()) continue;
                childItemList = parentWrapper.getChildItemList();
                childListItemCount = childItemList.size();
                for (j = 0; j < childListItemCount; ++j) {
                    this.mItemList.remove(fullCount + 1);
                }
                continue;
            }
            ++childCount;
        }
        this.notifyDataSetChanged();
    }

    protected Object getListItem(int position) {
        return this.mItemList.get(position);
    }

    private void expandViews(ParentWrapper parentWrapper, int parentIndex) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(parentIndex);
            if (viewHolder != null && !viewHolder.isExpanded()) {
                viewHolder.setExpanded(true);
                viewHolder.onExpansionToggled(false);
            }
            this.expandParentListItem(parentWrapper, parentIndex, false);
        }
    }

    private void collapseViews(ParentWrapper parentWrapper, int parentIndex) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(parentIndex);
            if (viewHolder != null && viewHolder.isExpanded()) {
                viewHolder.setExpanded(false);
                viewHolder.onExpansionToggled(true);
            }
            this.collapseParentListItem(parentWrapper, parentIndex, false);
        }
    }

    private void expandParentListItem(ParentWrapper parentWrapper, int parentIndex, boolean expansionTriggeredByListItemClick) {
        if (!parentWrapper.isExpanded()) {
            List<?> childItemList;
            parentWrapper.setExpanded(true);
            if (expansionTriggeredByListItemClick && this.mExpandCollapseListener != null) {
                int expandedCountBeforePosition = this.getExpandedItemCount(parentIndex);
                this.mExpandCollapseListener.onListItemExpanded(parentIndex - expandedCountBeforePosition);
            }
            if ((childItemList = parentWrapper.getChildItemList()) != null) {
                int childListItemCount = childItemList.size();
                for (int i = 0; i < childListItemCount; ++i) {
                    this.mItemList.add(parentIndex + i + 1, childItemList.get(i));
                    this.notifyItemInserted(parentIndex + i + 1);
                }
            }
        }
    }

    private void collapseParentListItem(ParentWrapper parentWrapper, int parentIndex, boolean collapseTriggeredByListItemClick) {
        if (parentWrapper.isExpanded()) {
            List<?> childItemList;
            parentWrapper.setExpanded(false);
            if (collapseTriggeredByListItemClick && this.mExpandCollapseListener != null) {
                int expandedCountBeforePosition = this.getExpandedItemCount(parentIndex);
                this.mExpandCollapseListener.onListItemCollapsed(parentIndex - expandedCountBeforePosition);
            }
            if ((childItemList = parentWrapper.getChildItemList()) != null) {
                for (int i = childItemList.size() - 1; i >= 0; --i) {
                    this.mItemList.remove(parentIndex + i + 1);
                    this.notifyItemRemoved(parentIndex + i + 1);
                }
            }
        }
    }

    private int getExpandedItemCount(int position) {
        if (position == 0) {
            return 0;
        }
        int expandedCount = 0;
        for (int i = 0; i < position; ++i) {
            Object listItem = this.getListItem(i);
            if (listItem instanceof ParentWrapper) continue;
            ++expandedCount;
        }
        return expandedCount;
    }

    public void notifyParentItemInserted(int parentPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int wrapperIndex = parentPosition < this.mParentItemList.size() - 1 ? this.getParentWrapperIndex(parentPosition) : this.mItemList.size();
        int sizeChanged = this.addParentWrapper(wrapperIndex, parentListItem);
        this.notifyItemRangeInserted(wrapperIndex, sizeChanged);
    }

    public void notifyParentItemRangeInserted(int parentPositionStart, int itemCount) {
        int initialWrapperIndex = parentPositionStart < this.mParentItemList.size() - 1 ? this.getParentWrapperIndex(parentPositionStart) : this.mItemList.size();
        int sizeChanged = 0;
        int wrapperIndex = initialWrapperIndex;
        int parentPositionEnd = parentPositionStart + itemCount;
        for (int i = parentPositionStart; i < parentPositionEnd; ++i) {
            ParentListItem parentListItem = this.mParentItemList.get(i);
            int changed = this.addParentWrapper(wrapperIndex, parentListItem);
            wrapperIndex += changed;
            sizeChanged += changed;
        }
        this.notifyItemRangeInserted(initialWrapperIndex, sizeChanged);
    }

    private int addParentWrapper(int wrapperIndex, ParentListItem parentListItem) {
        int sizeChanged = 1;
        ParentWrapper parentWrapper = new ParentWrapper(parentListItem);
        this.mItemList.add(wrapperIndex, parentWrapper);
        if (parentWrapper.isInitiallyExpanded()) {
            parentWrapper.setExpanded(true);
            List<?> childItemList = parentWrapper.getChildItemList();
            this.mItemList.addAll(wrapperIndex + sizeChanged, childItemList);
            sizeChanged += childItemList.size();
        }
        return sizeChanged;
    }

    public void notifyParentItemRemoved(int parentPosition) {
        int sizeChanged = 1;
        int wrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.remove(wrapperIndex);
        if (parentWrapper.isExpanded()) {
            int childListSize = parentWrapper.getChildItemList().size();
            for (int i = 0; i < childListSize; ++i) {
                this.mItemList.remove(wrapperIndex);
                ++sizeChanged;
            }
        }
        this.notifyItemRangeRemoved(wrapperIndex, sizeChanged);
    }

    public void notifyParentItemChanged(int parentPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int wrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(wrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        int sizeChanged = 1;
        if (parentWrapper.isExpanded()) {
            int childListSize = parentWrapper.getChildItemList().size();
            for (int i = 0; i < childListSize; ++i) {
                ++sizeChanged;
            }
        }
        this.notifyItemRangeChanged(wrapperIndex, sizeChanged);
    }

    public void notifyChildItemInserted(int parentPosition, int childPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        Object child = parentListItem.getChildItemList().get(childPosition);
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            this.mItemList.add(parentWrapperIndex + childPosition + 1, child);
            this.notifyItemInserted(parentWrapperIndex + childPosition + 1);
        }
    }

    public void notifyChildItemRemoved(int parentPosition, int childPosition) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            this.mItemList.remove(parentWrapperIndex + childPosition + 1);
            this.notifyItemRemoved(parentWrapperIndex + childPosition + 1);
        }
    }

    public void notifyChildItemChanged(int parentPosition, int childPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        if (parentWrapper.isExpanded()) {
            this.notifyItemChanged(parentWrapperIndex + childPosition + 1);
        }
    }

    private HashMap<Integer, Boolean> generateExpandedStateMap() {
        HashMap<Integer, Boolean> parentListItemHashMap = new HashMap<Integer, Boolean>();
        int childCount = 0;
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (this.mItemList.get(i) == null) continue;
            Object listItem = this.getListItem(i);
            if (listItem instanceof ParentWrapper) {
                ParentWrapper parentWrapper = (ParentWrapper)listItem;
                parentListItemHashMap.put(i - childCount, parentWrapper.isExpanded());
                continue;
            }
            ++childCount;
        }
        return parentListItemHashMap;
    }

    private int getParentWrapperIndex(int parentIndex) {
        int parentCount = 0;
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (!(this.mItemList.get(i) instanceof ParentWrapper) || ++parentCount <= parentIndex) continue;
            return i;
        }
        return -1;
    }

    private ParentWrapper getParentWrapper(ParentListItem parentListItem) {
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            Object listItem = this.mItemList.get(i);
            if (!(listItem instanceof ParentWrapper) || !((ParentWrapper)listItem).getParentListItem().equals(parentListItem)) continue;
            return (ParentWrapper)listItem;
        }
        return null;
    }

    public static interface ExpandCollapseListener {
        public void onListItemExpanded(int var1);

        public void onListItemCollapsed(int var1);
    }
}

