/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.bignerdranch.expandablerecyclerview.Adapter.ExpandableRecyclerAdapterHelper;
import com.bignerdranch.expandablerecyclerview.ClickListeners.ExpandCollapseListener;
import com.bignerdranch.expandablerecyclerview.ClickListeners.ParentItemClickListener;
import com.bignerdranch.expandablerecyclerview.Model.ParentObject;
import com.bignerdranch.expandablerecyclerview.Model.ParentWrapper;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ChildViewHolder;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ParentViewHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class ExpandableRecyclerAdapter<PVH extends ParentViewHolder, CVH extends ChildViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ParentItemClickListener {
    private static final String TAG = ExpandableRecyclerAdapter.class.getClass().getSimpleName();
    private static final String STABLE_ID_MAP = "ExpandableRecyclerAdapter.StableIdMap";
    private static final String STABLE_ID_LIST = "ExpandableRecyclerAdapter.StableIdList";
    private static final int TYPE_PARENT = 0;
    private static final int TYPE_CHILD = 1;
    public static final int CUSTOM_ANIMATION_VIEW_NOT_SET = -1;
    public static final long DEFAULT_ROTATE_DURATION_MS = 200L;
    public static final long CUSTOM_ANIMATION_DURATION_NOT_SET = -1L;
    protected Context mContext;
    protected List<ParentObject> mParentItemList;
    private List<Object> mHelperItemList;
    private HashMap<Long, Boolean> mStableIdMap;
    private ExpandCollapseListener mExpandCollapseListener;
    private boolean mParentAndIconClickable = false;
    private int mCustomParentAnimationViewId = -1;
    private long mAnimationDuration = -1L;

    public ExpandableRecyclerAdapter(Context context, List<ParentObject> parentItemList) {
        this.mContext = context;
        this.mParentItemList = parentItemList;
        this.mHelperItemList = ExpandableRecyclerAdapterHelper.generateHelperItemList(parentItemList);
        this.mStableIdMap = this.generateStableIdMapFromList(this.mHelperItemList);
    }

    public ExpandableRecyclerAdapter(Context context, List<ParentObject> parentItemList, int customParentAnimationViewId) {
        this.mContext = context;
        this.mParentItemList = parentItemList;
        this.mHelperItemList = ExpandableRecyclerAdapterHelper.generateHelperItemList(parentItemList);
        this.mStableIdMap = this.generateStableIdMapFromList(this.mHelperItemList);
        this.mCustomParentAnimationViewId = customParentAnimationViewId;
    }

    public ExpandableRecyclerAdapter(Context context, List<ParentObject> parentItemList, int customParentAnimationViewId, long animationDuration) {
        this.mContext = context;
        this.mParentItemList = parentItemList;
        this.mHelperItemList = ExpandableRecyclerAdapterHelper.generateHelperItemList(parentItemList);
        this.mStableIdMap = this.generateStableIdMapFromList(this.mHelperItemList);
        this.mCustomParentAnimationViewId = customParentAnimationViewId;
        this.mAnimationDuration = animationDuration;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == 0) {
            PVH pvh = this.onCreateParentViewHolder(viewGroup);
            ((ParentViewHolder)((Object)pvh)).setParentItemClickListener(this);
            return pvh;
        }
        if (viewType == 1) {
            return this.onCreateChildViewHolder(viewGroup);
        }
        throw new IllegalStateException("Incorrect ViewType found");
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Object helperItem = this.getHelperItem(position);
        if (helperItem instanceof ParentWrapper) {
            ParentViewHolder parentViewHolder = (ParentViewHolder)holder;
            if (this.mParentAndIconClickable) {
                if (this.mCustomParentAnimationViewId != -1 && this.mAnimationDuration != -1L) {
                    parentViewHolder.setCustomClickableViewAndItem(this.mCustomParentAnimationViewId);
                    parentViewHolder.setAnimationDuration(this.mAnimationDuration);
                } else if (this.mCustomParentAnimationViewId != -1) {
                    parentViewHolder.setCustomClickableViewAndItem(this.mCustomParentAnimationViewId);
                    parentViewHolder.cancelAnimation();
                } else {
                    parentViewHolder.setMainItemClickToExpand();
                }
            } else if (this.mCustomParentAnimationViewId != -1 && this.mAnimationDuration != -1L) {
                parentViewHolder.setCustomClickableViewOnly(this.mCustomParentAnimationViewId);
                parentViewHolder.setAnimationDuration(this.mAnimationDuration);
            } else if (this.mCustomParentAnimationViewId != -1) {
                parentViewHolder.setCustomClickableViewOnly(this.mCustomParentAnimationViewId);
                parentViewHolder.cancelAnimation();
            } else {
                parentViewHolder.setMainItemClickToExpand();
            }
            ParentWrapper parentWrapper = (ParentWrapper)helperItem;
            parentViewHolder.setExpanded(parentWrapper.isExpanded());
            this.onBindParentViewHolder(parentViewHolder, position, parentWrapper.getParentObject());
        } else {
            if (helperItem == null) {
                throw new IllegalStateException("Incorrect ViewHolder found");
            }
            this.onBindChildViewHolder((ChildViewHolder)holder, position, helperItem);
        }
    }

    public abstract PVH onCreateParentViewHolder(ViewGroup var1);

    public abstract CVH onCreateChildViewHolder(ViewGroup var1);

    public abstract void onBindParentViewHolder(PVH var1, int var2, Object var3);

    public abstract void onBindChildViewHolder(CVH var1, int var2, Object var3);

    public int getItemCount() {
        return this.mHelperItemList.size();
    }

    public int getItemViewType(int position) {
        Object helperItem = this.getHelperItem(position);
        if (helperItem instanceof ParentWrapper) {
            return 0;
        }
        if (helperItem == null) {
            throw new IllegalStateException("Null object added");
        }
        return 1;
    }

    @Override
    public void onParentItemClickListener(int position) {
        Object helperItem = this.getHelperItem(position);
        if (helperItem instanceof ParentWrapper) {
            ParentObject parentObject = ((ParentWrapper)helperItem).getParentObject();
            this.expandParent(parentObject, position);
        }
    }

    public void setParentClickableViewAnimationDefaultDuration() {
        this.mAnimationDuration = 200L;
    }

    public void setParentClickableViewAnimationDuration(long animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public void setCustomParentAnimationViewId(int customParentAnimationViewId) {
        this.mCustomParentAnimationViewId = customParentAnimationViewId;
    }

    public void setParentAndIconExpandOnClick(boolean parentAndIconClickable) {
        this.mParentAndIconClickable = parentAndIconClickable;
    }

    public void removeAnimation() {
        this.mCustomParentAnimationViewId = -1;
        this.mAnimationDuration = -1L;
    }

    public void addExpandCollapseListener(ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    private void expandParent(ParentObject parentObject, int position) {
        block7: {
            ParentWrapper parentWrapper;
            block6: {
                parentWrapper = (ParentWrapper)this.getHelperItem(position);
                if (parentWrapper == null) {
                    return;
                }
                if (!parentWrapper.isExpanded()) break block6;
                parentWrapper.setExpanded(false);
                if (this.mExpandCollapseListener != null) {
                    int expandedCountBeforePosition = this.getExpandedItemCount(position);
                    this.mExpandCollapseListener.onRecyclerViewItemCollapsed(position - expandedCountBeforePosition);
                }
                this.mStableIdMap.put(parentWrapper.getStableId(), false);
                List<Object> childObjectList = parentWrapper.getParentObject().getChildObjectList();
                if (childObjectList == null) break block7;
                for (int i = childObjectList.size() - 1; i >= 0; --i) {
                    this.mHelperItemList.remove(position + i + 1);
                    this.notifyItemRemoved(position + i + 1);
                }
                break block7;
            }
            parentWrapper.setExpanded(true);
            if (this.mExpandCollapseListener != null) {
                int expandedCountBeforePosition = this.getExpandedItemCount(position);
                this.mExpandCollapseListener.onRecyclerViewItemExpanded(position - expandedCountBeforePosition);
            }
            this.mStableIdMap.put(parentWrapper.getStableId(), true);
            List<Object> childObjectList = parentWrapper.getParentObject().getChildObjectList();
            if (childObjectList != null) {
                for (int i = 0; i < childObjectList.size(); ++i) {
                    this.mHelperItemList.add(position + i + 1, childObjectList.get(i));
                    this.notifyItemInserted(position + i + 1);
                }
            }
        }
    }

    private int getExpandedItemCount(int position) {
        if (position == 0) {
            return 0;
        }
        int expandedCount = 0;
        for (int i = 0; i < position; ++i) {
            Object object = this.getHelperItem(i);
            if (object instanceof ParentWrapper) continue;
            ++expandedCount;
        }
        return expandedCount;
    }

    private HashMap<Long, Boolean> generateStableIdMapFromList(List<Object> itemList) {
        HashMap<Long, Boolean> parentObjectHashMap = new HashMap<Long, Boolean>();
        for (int i = 0; i < itemList.size(); ++i) {
            Object helperItem;
            if (itemList.get(i) == null || !((helperItem = this.getHelperItem(i)) instanceof ParentWrapper)) continue;
            ParentWrapper parentWrapper = (ParentWrapper)helperItem;
            parentObjectHashMap.put(parentWrapper.getStableId(), parentWrapper.isExpanded());
        }
        return parentObjectHashMap;
    }

    private ArrayList<Object> generateObjectList(List<ParentObject> parentObjectList) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (ParentObject parentObject : parentObjectList) {
            objectList.add(parentObject);
        }
        return objectList;
    }

    public Bundle onSaveInstanceState(Bundle savedInstanceStateBundle) {
        savedInstanceStateBundle.putSerializable(STABLE_ID_MAP, this.mStableIdMap);
        return savedInstanceStateBundle;
    }

    public void onRestoreInstanceState(Bundle savedInstanceStateBundle) {
        if (savedInstanceStateBundle == null) {
            return;
        }
        if (!savedInstanceStateBundle.containsKey(STABLE_ID_MAP)) {
            return;
        }
        this.mStableIdMap = (HashMap)savedInstanceStateBundle.getSerializable(STABLE_ID_MAP);
        for (int i = 0; i < this.mHelperItemList.size(); ++i) {
            Object helperItem = this.getHelperItem(i);
            if (!(helperItem instanceof ParentWrapper)) continue;
            ParentWrapper parentWrapper = (ParentWrapper)helperItem;
            if (this.mStableIdMap.containsKey(parentWrapper.getStableId())) {
                int j;
                List<Object> childObjectList;
                parentWrapper.setExpanded(this.mStableIdMap.get(parentWrapper.getStableId()));
                if (parentWrapper.isExpanded() && !parentWrapper.getParentObject().isInitiallyExpanded()) {
                    childObjectList = parentWrapper.getParentObject().getChildObjectList();
                    if (childObjectList == null) continue;
                    for (j = 0; j < childObjectList.size(); ++j) {
                        this.mHelperItemList.add(++i, childObjectList.get(j));
                    }
                    continue;
                }
                if (parentWrapper.isExpanded() || !parentWrapper.getParentObject().isInitiallyExpanded()) continue;
                childObjectList = parentWrapper.getParentObject().getChildObjectList();
                for (j = 0; j < childObjectList.size(); ++j) {
                    this.mHelperItemList.remove(i + 1);
                }
                continue;
            }
            parentWrapper.setExpanded(false);
        }
        this.notifyDataSetChanged();
    }

    private Object getHelperItem(int position) {
        return this.mHelperItemList.get(position);
    }
}

