/*
 * Decompiled with CFR 0.152.
 */
package com.benasher44.uuid;

import com.benasher44.uuid.PlatformKt;
import com.benasher44.uuid.UuidKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0002"}, d2={"Lcom/benasher44/uuid/Uuid;", "", "uuid", "", "([B)V", "leastSignificantBits", "", "getLeastSignificantBits", "()J", "leastSignificantBits$delegate", "Lkotlin/Lazy;", "mostSignificantBits", "getMostSignificantBits", "mostSignificantBits$delegate", "getUuid", "()[B", "variant", "", "getVariant", "()I", "variant$delegate", "version", "getVersion", "version$delegate", "equals", "", "other", "hashCode", "toString", "", "Companion"})
public final class Uuid {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy mostSignificantBits$delegate;
    @NotNull
    private final Lazy leastSignificantBits$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy variant$delegate;
    @NotNull
    private final byte[] uuid;
    @NotNull
    private static final List<IntRange> uuidCharRanges;
    @NotNull
    private static final List<Integer> hyphenIndices;
    private static final List<IntRange> uuidByteRanges;
    @NotNull
    private static final List<Character> uuidChars;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Uuid.class), "mostSignificantBits", "getMostSignificantBits()J")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Uuid.class), "leastSignificantBits", "getLeastSignificantBits()J")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Uuid.class), "version", "getVersion()I")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Uuid.class), "variant", "getVariant()I"))};
        Companion = new Companion(null);
        uuidCharRanges = CollectionsKt.listOf((Object[])new IntRange[]{RangesKt.until((int)0, (int)8), RangesKt.until((int)9, (int)13), RangesKt.until((int)14, (int)18), RangesKt.until((int)19, (int)23), RangesKt.until((int)24, (int)36)});
        hyphenIndices = CollectionsKt.listOf((Object[])new Integer[]{8, 13, 18, 23});
        uuidByteRanges = CollectionsKt.listOf((Object[])new IntRange[]{RangesKt.until((int)0, (int)4), RangesKt.until((int)4, (int)6), RangesKt.until((int)6, (int)8), RangesKt.until((int)8, (int)10), RangesKt.until((int)10, (int)16)});
        char c = '0';
        CharRange charRange = new CharRange(c, '9');
        c = 'a';
        uuidChars = CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)new CharRange(c, 'f')));
    }

    public final long getMostSignificantBits() {
        Lazy lazy = this.mostSignificantBits$delegate;
        Uuid uuid = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getLeastSignificantBits() {
        Lazy lazy = this.leastSignificantBits$delegate;
        Uuid uuid = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    public final int getVersion() {
        Lazy lazy = this.version$delegate;
        Uuid uuid = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getVariant() {
        Lazy lazy = this.variant$delegate;
        Uuid uuid = this;
        KProperty kProperty = $$delegatedProperties[3];
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        char[] characters = new char[UuidKt.getUUID_STRING_LENGTH()];
        int charIndex = 0;
        Iterator<IntRange> iterator = uuidByteRanges.iterator();
        while (iterator.hasNext()) {
            int n;
            IntRange range;
            IntRange intRange = range = iterator.next();
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    byte octetPair = this.uuid[i];
                    int left = octetPair >> 4 & 0xF;
                    int right = octetPair & 0xF;
                    characters[charIndex++] = uuidChars.get(left).charValue();
                    characters[charIndex++] = uuidChars.get(right).charValue();
                    if (i == n) break;
                    ++i;
                }
            }
            if (charIndex >= UuidKt.getUUID_STRING_LENGTH()) continue;
            characters[charIndex++] = 45;
        }
        boolean bl = false;
        return new String(characters);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Uuid)) {
            return false;
        }
        byte[] byArray = ((Uuid)other).uuid;
        byte[] byArray2 = this.uuid;
        boolean bl = false;
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        byte[] byArray = this.uuid;
        boolean bl = false;
        return Arrays.hashCode(byArray);
    }

    @NotNull
    public final byte[] getUuid() {
        return this.uuid;
    }

    public Uuid(@NotNull byte[] uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        this.uuid = uuid;
        this.mostSignificantBits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Uuid this$0;

            /*
             * WARNING - void declaration
             */
            public final long invoke() {
                void $this$fold$iv;
                int n = 0;
                Iterable iterable = (Iterable)new IntRange(n, 7);
                long initial$iv = 0L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                Iterator<T> iterator = $this$fold$iv.iterator();
                while (iterator.hasNext()) {
                    void i;
                    int element$iv;
                    int n2 = element$iv = ((IntIterator)iterator).nextInt();
                    long bits = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = bits << 8 | (long)this.this$0.getUuid()[i] & 0xFFL;
                }
                return accumulator$iv;
            }
            {
                this.this$0 = uuid;
                super(0);
            }
        }));
        this.leastSignificantBits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Uuid this$0;

            /*
             * WARNING - void declaration
             */
            public final long invoke() {
                void $this$fold$iv;
                int n = 8;
                Iterable iterable = (Iterable)new IntRange(n, 15);
                long initial$iv = 0L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                Iterator<T> iterator = $this$fold$iv.iterator();
                while (iterator.hasNext()) {
                    void i;
                    int element$iv;
                    int n2 = element$iv = ((IntIterator)iterator).nextInt();
                    long bits = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = bits << 8 | (long)this.this$0.getUuid()[i] & 0xFFL;
                }
                return accumulator$iv;
            }
            {
                this.this$0 = uuid;
                super(0);
            }
        }));
        this.version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Uuid this$0;

            public final int invoke() {
                return (int)(this.this$0.getMostSignificantBits() >> 12 & 0xFL);
            }
            {
                this.this$0 = uuid;
                super(0);
            }
        }));
        this.variant$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Uuid this$0;

            public final int invoke() {
                return (int)(this.this$0.getLeastSignificantBits() >>> (int)((long)64 - (this.this$0.getLeastSignificantBits() >>> 62)) & this.this$0.getLeastSignificantBits() >> 63);
            }
            {
                this.this$0 = uuid;
                super(0);
            }
        }));
        byte[] byArray = this.uuid;
        boolean bl = false;
        if (byArray.length != UuidKt.getUUID_BYTES()) {
            byArray = this.uuid;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid UUID bytes. Expected ").append(UuidKt.getUUID_BYTES()).append(" bytes; found ");
            bl = false;
            int n = byArray.length;
            String string = stringBuilder.append(n).toString();
            throw (Throwable)new IllegalArgumentException(string);
        }
        PlatformKt.freeze(this);
    }

    public /* synthetic */ Uuid(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = Uuid.Companion.genUuid();
        }
        this(byArray);
    }

    public Uuid() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/benasher44/uuid/Uuid$Companion;", "", "()V", "hyphenIndices", "", "", "getHyphenIndices$uuid", "()Ljava/util/List;", "uuidByteRanges", "Lkotlin/ranges/IntRange;", "uuidCharRanges", "getUuidCharRanges$uuid", "uuidChars", "", "getUuidChars$uuid", "genUuid", "", "halfByteFromChar", "char", "(C)Ljava/lang/Integer;", "parse", "Lcom/benasher44/uuid/Uuid;", "from", "", "uuid"})
    public static final class Companion {
        private final byte[] genUuid() {
            byte[] bytes = PlatformKt.getRandomUuidBytes();
            bytes[6] = (byte)(bytes[6] & 0xF | 0x40);
            bytes[8] = (byte)(bytes[8] & 0x3F | 0x80);
            return bytes;
        }

        @NotNull
        public final List<IntRange> getUuidCharRanges$uuid() {
            return uuidCharRanges;
        }

        @NotNull
        public final List<Integer> getHyphenIndices$uuid() {
            return hyphenIndices;
        }

        private final Integer halfByteFromChar(char c) {
            char c2 = c;
            char c3 = c2;
            return '0' <= c3 && '9' >= c3 ? Integer.valueOf(c - 48) : ('a' <= (c3 = c2) && 'f' >= c3 ? Integer.valueOf(c - 87) : ('A' <= (c3 = c2) && 'F' >= c3 ? Integer.valueOf(c - 55) : null));
        }

        @Nullable
        public final Uuid parse(@NotNull String from) {
            Object v0;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
                if (from.length() != UuidKt.getUUID_STRING_LENGTH()) {
                    return null;
                }
                Iterable iterable = this.getHyphenIndices$uuid();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    int it = ((Number)t).intValue();
                    boolean bl3 = false;
                    if (!(from.charAt(it) != '-')) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            if (v0 != null) {
                return null;
            }
            byte[] bytes = new byte[UuidKt.getUUID_BYTES()];
            int n = 0;
            for (IntRange range : this.getUuidCharRanges$uuid()) {
                int i = range.getStart();
                while (i < range.getEndInclusive()) {
                    Integer left = this.halfByteFromChar(from.charAt(i++));
                    Integer right = this.halfByteFromChar(from.charAt(i++));
                    if (left == null || right == null) {
                        return null;
                    }
                    bytes[n++] = (byte)(left << 4 | right);
                }
            }
            return new Uuid(bytes);
        }

        @NotNull
        public final List<Character> getUuidChars$uuid() {
            return uuidChars;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

