/*
 * Decompiled with CFR 0.152.
 */
package com.benasher44.uuid;

import com.benasher44.uuid.PlatformKt;
import com.benasher44.uuid.UuidKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0002"}, d2={"Lcom/benasher44/uuid/UUID;", "", "uuid", "", "([B)V", "getUuid", "()[B", "equals", "", "other", "hashCode", "", "toString", "", "Companion"})
public final class UUID {
    @NotNull
    private final byte[] uuid;
    @NotNull
    private static final List<IntRange> uuidCharRanges;
    @NotNull
    private static final List<Integer> hyphenIndices;
    private static final List<IntRange> uuidByteRanges;
    @NotNull
    private static final List<Character> uuidChars;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        char[] characters = new char[UuidKt.getUUID_STRING_LENGTH()];
        int charIndex = 0;
        Iterator<IntRange> iterator = uuidByteRanges.iterator();
        while (iterator.hasNext()) {
            int n;
            IntRange range;
            IntRange intRange = range = iterator.next();
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    byte octetPair = this.uuid[i];
                    int left = octetPair >> 4 & 0xF;
                    int right = octetPair & 0xF;
                    characters[charIndex++] = uuidChars.get(left).charValue();
                    characters[charIndex++] = uuidChars.get(right).charValue();
                    if (i == n) break;
                    ++i;
                }
            }
            if (charIndex >= UuidKt.getUUID_STRING_LENGTH()) continue;
            characters[charIndex++] = 45;
        }
        boolean bl = false;
        return new String(characters);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof UUID)) {
            return false;
        }
        byte[] byArray = ((UUID)other).uuid;
        byte[] byArray2 = this.uuid;
        boolean bl = false;
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        byte[] byArray = this.uuid;
        boolean bl = false;
        return Arrays.hashCode(byArray);
    }

    @NotNull
    public final byte[] getUuid() {
        return this.uuid;
    }

    public UUID(@NotNull byte[] uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        byte[] byArray = this.uuid = uuid;
        boolean bl = false;
        if (byArray.length != UuidKt.getUUID_BYTES()) {
            byArray = this.uuid;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid UUID bytes. Expected ").append(UuidKt.getUUID_BYTES()).append(" bytes; found ");
            bl = false;
            int n = byArray.length;
            String string = stringBuilder.append(n).toString();
            throw (Throwable)new IllegalArgumentException(string);
        }
        PlatformKt.freeze(this);
    }

    public /* synthetic */ UUID(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = UUID.Companion.genUuid();
        }
        this(byArray);
    }

    public UUID() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        uuidCharRanges = CollectionsKt.listOf((Object[])new IntRange[]{RangesKt.until((int)0, (int)8), RangesKt.until((int)9, (int)13), RangesKt.until((int)14, (int)18), RangesKt.until((int)19, (int)23), RangesKt.until((int)24, (int)36)});
        hyphenIndices = CollectionsKt.listOf((Object[])new Integer[]{8, 13, 18, 23});
        uuidByteRanges = CollectionsKt.listOf((Object[])new IntRange[]{RangesKt.until((int)0, (int)4), RangesKt.until((int)4, (int)6), RangesKt.until((int)6, (int)8), RangesKt.until((int)8, (int)10), RangesKt.until((int)10, (int)16)});
        char c = '0';
        CharRange charRange = new CharRange(c, '9');
        c = 'a';
        uuidChars = CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)new CharRange(c, 'f')));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/benasher44/uuid/UUID$Companion;", "", "()V", "hyphenIndices", "", "", "getHyphenIndices$uuid", "()Ljava/util/List;", "uuidByteRanges", "Lkotlin/ranges/IntRange;", "uuidCharRanges", "getUuidCharRanges$uuid", "uuidChars", "", "getUuidChars$uuid", "genUuid", "", "halfByteFromChar", "char", "(C)Ljava/lang/Integer;", "parse", "Lcom/benasher44/uuid/UUID;", "from", "", "uuid"})
    public static final class Companion {
        private final byte[] genUuid() {
            byte[] bytes = PlatformKt.getRandomUUIDBytes();
            bytes[7] = (byte)(bytes[6] & 0xF | 0x40);
            bytes[8] = (byte)(bytes[8] & 0x3F | 0x80);
            return bytes;
        }

        @NotNull
        public final List<IntRange> getUuidCharRanges$uuid() {
            return uuidCharRanges;
        }

        @NotNull
        public final List<Integer> getHyphenIndices$uuid() {
            return hyphenIndices;
        }

        private final Integer halfByteFromChar(char c) {
            char c2 = c;
            char c3 = c2;
            return '0' <= c3 && '9' >= c3 ? Integer.valueOf(c - 48) : ('a' <= (c3 = c2) && 'f' >= c3 ? Integer.valueOf(c - 87) : ('A' <= (c3 = c2) && 'F' >= c3 ? Integer.valueOf(c - 55) : null));
        }

        @Nullable
        public final UUID parse(@NotNull String from) {
            Object v0;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
                if (from.length() != UuidKt.getUUID_STRING_LENGTH()) {
                    return null;
                }
                Iterable iterable = this.getHyphenIndices$uuid();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    int it = ((Number)t).intValue();
                    boolean bl3 = false;
                    if (!(from.charAt(it) != '-')) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            if (v0 != null) {
                return null;
            }
            byte[] bytes = new byte[UuidKt.getUUID_BYTES()];
            int n = 0;
            for (IntRange range : this.getUuidCharRanges$uuid()) {
                int i = range.getStart();
                while (i < range.getEndInclusive()) {
                    Integer left = this.halfByteFromChar(from.charAt(i++));
                    Integer right = this.halfByteFromChar(from.charAt(i++));
                    if (left == null || right == null) {
                        return null;
                    }
                    bytes[n++] = (byte)(left << 4 | right);
                }
            }
            return new UUID(bytes);
        }

        @NotNull
        public final List<Character> getUuidChars$uuid() {
            return uuidChars;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

