/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.List;

public class LetterListView
extends View {
    OnTouchingLetterChangedListener onTouchingLetterChangedListener;
    List<String> b;
    int choose = -1;
    Paint paint = new Paint();
    boolean showBkg = false;

    public LetterListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public LetterListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LetterListView(Context context, List<String> b) {
        super(context);
        this.b = b;
    }

    public void setB(List<String> b) {
        this.b = b;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showBkg) {
            canvas.drawColor(Color.parseColor((String)"#00000000"));
        }
        int height = this.getHeight();
        int width = this.getWidth() - 30;
        if (this.b.size() > 0) {
            int singleHeight = height / this.b.size();
            int i = 0;
            while (i < this.b.size()) {
                this.paint.setColor(Color.parseColor((String)"#2796c4"));
                this.paint.setTextSize(17.0f);
                this.paint.setTypeface(Typeface.DEFAULT_BOLD);
                this.paint.setAntiAlias(true);
                if (i == this.choose) {
                    this.paint.setColor(-7829368);
                    this.paint.setFakeBoldText(true);
                }
                float xPos = (float)(width / 2) - this.paint.measureText(this.b.get(i)) / 2.0f;
                float yPos = singleHeight * i + singleHeight;
                canvas.drawText(this.b.get(i).toUpperCase(), xPos, yPos, this.paint);
                this.paint.reset();
                ++i;
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float y = event.getY();
        int oldChoose = this.choose;
        OnTouchingLetterChangedListener listener = this.onTouchingLetterChangedListener;
        int c = (int)(y / (float)this.getHeight() * (float)this.b.size());
        switch (action) {
            case 0: {
                this.showBkg = true;
                if (oldChoose == c || listener == null || c < 0 || c >= this.b.size()) break;
                listener.onTouchingLetterChanged(c);
                this.choose = c;
                this.invalidate();
                break;
            }
            case 2: {
                if (oldChoose == c || listener == null || c < 0 || c >= this.b.size()) break;
                listener.onTouchingLetterChanged(c);
                this.choose = c;
                this.invalidate();
                break;
            }
            case 1: {
                this.showBkg = false;
                this.choose = -1;
                this.invalidate();
            }
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public void setOnTouchingLetterChangedListener(OnTouchingLetterChangedListener onTouchingLetterChangedListener) {
        this.onTouchingLetterChangedListener = onTouchingLetterChangedListener;
    }

    public static interface OnTouchingLetterChangedListener {
        public void onTouchingLetterChanged(int var1);
    }
}

