/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.Toast;
import com.tencent.weibo.sdk.android.api.FriendAPI;
import com.tencent.weibo.sdk.android.api.LbsAPI;
import com.tencent.weibo.sdk.android.api.TimeLineAPI;
import com.tencent.weibo.sdk.android.api.UserAPI;
import com.tencent.weibo.sdk.android.api.WeiboAPI;
import com.tencent.weibo.sdk.android.api.util.Util;
import com.tencent.weibo.sdk.android.component.GeneralDataShowActivity;
import com.tencent.weibo.sdk.android.model.AccountModel;
import com.tencent.weibo.sdk.android.model.ModelResult;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import java.io.InputStream;

public class GeneralInterfaceActivity
extends Activity
implements View.OnClickListener {
    private Button homeTimeLine;
    private Button userTimeLine;
    private Button addWeibo;
    private Button addPic;
    private Button addPicUrl;
    private Button htTimeLine;
    private Button userInfo;
    private Button userOtherInfo;
    private Button userInfos;
    private Button friendAdd;
    private Button friendIdolList;
    private Button friendFunsList;
    private Button friendMutualList;
    private Button friendCheck;
    private Button tReList;
    private Button friendGetIntimateFriend;
    private Button lbsGetAroundPeople;
    private Button lbsGetAroundNew;
    private Button deviceStatus;
    private Button errorReport;
    private String accessToken;
    private FriendAPI friendAPI;
    private TimeLineAPI timeLineAPI;
    private WeiboAPI weiboAPI;
    private UserAPI userAPI;
    private LbsAPI lbsAPI;
    private HttpCallback mCallBack;
    private PopupWindow loadingWindow = null;
    private ProgressBar progressBar = null;
    private ScrollView scrollView = null;
    private Context context = null;
    private String requestFormat = "json";
    private double longitude = 0.0;
    private double latitude = 0.0;
    private Location mLocation;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.accessToken = Util.getSharePersistent((Context)this.getApplicationContext(), (String)"ACCESS_TOKEN");
        if (this.accessToken == null || "".equals(this.accessToken)) {
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u5148\u6388\u6743", (int)0).show();
            this.finish();
            return;
        }
        AccountModel account = new AccountModel(this.accessToken);
        this.friendAPI = new FriendAPI(account);
        this.timeLineAPI = new TimeLineAPI(account);
        this.weiboAPI = new WeiboAPI(account);
        this.userAPI = new UserAPI(account);
        this.lbsAPI = new LbsAPI(account);
        this.mCallBack = new HttpCallback(){

            public void onResult(Object object) {
                ModelResult result = (ModelResult)object;
                if (GeneralInterfaceActivity.this.loadingWindow != null && GeneralInterfaceActivity.this.loadingWindow.isShowing()) {
                    GeneralInterfaceActivity.this.loadingWindow.dismiss();
                }
                if (result != null) {
                    Toast.makeText((Context)GeneralInterfaceActivity.this, (CharSequence)"\u6210\u529f", (int)0).show();
                    Intent i = new Intent((Context)GeneralInterfaceActivity.this, GeneralDataShowActivity.class);
                    i.putExtra("data", result.getObj().toString());
                    GeneralInterfaceActivity.this.startActivity(i);
                } else {
                    Toast.makeText((Context)GeneralInterfaceActivity.this, (CharSequence)"\u53d1\u751f\u5f02\u5e38", (int)0).show();
                }
            }
        };
        this.progressBar = new ProgressBar((Context)this);
        this.loadingWindow = new PopupWindow((View)this.progressBar, 100, 100);
        this.context = this.getApplicationContext();
        this.mLocation = Util.getLocation((Context)this.context);
        if (this.mLocation != null) {
            this.longitude = this.mLocation.getLongitude();
            this.latitude = this.mLocation.getLatitude();
        }
        this.initInterface();
    }

    public void initInterface() {
        this.scrollView = new ScrollView((Context)this);
        TableLayout table = new TableLayout((Context)this);
        TableLayout.LayoutParams paramsTable = new TableLayout.LayoutParams(-1, -1);
        table.setLayoutParams((ViewGroup.LayoutParams)paramsTable);
        TableRow row1 = new TableRow((Context)this);
        this.homeTimeLine = new Button((Context)this);
        this.homeTimeLine.setText((CharSequence)"\u4e3b\u4eba\u9875\u65f6\u95f4\u7ebf");
        this.homeTimeLine.setId(1001);
        this.homeTimeLine.setOnClickListener((View.OnClickListener)this);
        row1.addView((View)this.homeTimeLine);
        this.userTimeLine = new Button((Context)this);
        this.userTimeLine.setText((CharSequence)"\u5ba2\u4eba\u9875\u65f6\u95f4\u7ebf");
        this.userTimeLine.setId(1002);
        this.userTimeLine.setOnClickListener((View.OnClickListener)this);
        row1.addView((View)this.userTimeLine);
        table.addView((View)row1);
        TableRow row2 = new TableRow((Context)this);
        this.addWeibo = new Button((Context)this);
        this.addWeibo.setText((CharSequence)"\u666e\u901a\u53d1\u8868\u63a5\u53e3");
        this.addWeibo.setId(1003);
        this.addWeibo.setOnClickListener((View.OnClickListener)this);
        row2.addView((View)this.addWeibo);
        this.addPic = new Button((Context)this);
        this.addPic.setText((CharSequence)"\u53d1\u8868\u5e26\u56fe\u5fae\u535a");
        this.addPic.setId(1004);
        this.addPic.setOnClickListener((View.OnClickListener)this);
        row2.addView((View)this.addPic);
        table.addView((View)row2);
        TableRow row3 = new TableRow((Context)this);
        this.addPicUrl = new Button((Context)this);
        this.addPicUrl.setText((CharSequence)"\u53d1\u8868\u5e26\u7f51\u7edc\u56fe\u7247\u5fae\u535a");
        this.addPicUrl.setId(1005);
        this.addPicUrl.setOnClickListener((View.OnClickListener)this);
        row3.addView((View)this.addPicUrl);
        this.htTimeLine = new Button((Context)this);
        this.htTimeLine.setText((CharSequence)"\u8bdd\u9898\u65f6\u95f4\u7ebf");
        this.htTimeLine.setId(1006);
        this.htTimeLine.setOnClickListener((View.OnClickListener)this);
        row3.addView((View)this.htTimeLine);
        table.addView((View)row3);
        TableRow row4 = new TableRow((Context)this);
        this.userInfo = new Button((Context)this);
        this.userInfo.setText((CharSequence)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        this.userInfo.setId(1007);
        this.userInfo.setOnClickListener((View.OnClickListener)this);
        row4.addView((View)this.userInfo);
        this.userOtherInfo = new Button((Context)this);
        this.userOtherInfo.setText((CharSequence)"\u83b7\u53d6\u4ed6\u4eba\u4fe1\u606f");
        this.userOtherInfo.setId(1008);
        this.userOtherInfo.setOnClickListener((View.OnClickListener)this);
        row4.addView((View)this.userOtherInfo);
        table.addView((View)row4);
        TableRow row5 = new TableRow((Context)this);
        this.userInfos = new Button((Context)this);
        this.userInfos.setText((CharSequence)"\u83b7\u53d6\u4e00\u6279\u4eba\u4fe1\u606f");
        this.userInfos.setId(1009);
        this.userInfos.setOnClickListener((View.OnClickListener)this);
        row5.addView((View)this.userInfos);
        this.friendAdd = new Button((Context)this);
        this.friendAdd.setText((CharSequence)"\u6536\u542c\u67d0\u4e2a\u7528\u6237");
        this.friendAdd.setId(1010);
        this.friendAdd.setOnClickListener((View.OnClickListener)this);
        row5.addView((View)this.friendAdd);
        table.addView((View)row5);
        TableRow row6 = new TableRow((Context)this);
        this.friendIdolList = new Button((Context)this);
        this.friendIdolList.setText((CharSequence)"\u83b7\u53d6\u5076\u50cf\u5217\u8868");
        this.friendIdolList.setId(1011);
        this.friendIdolList.setOnClickListener((View.OnClickListener)this);
        row6.addView((View)this.friendIdolList);
        this.friendFunsList = new Button((Context)this);
        this.friendFunsList.setText((CharSequence)"\u83b7\u53d6\u7c89\u4e1d\u5217\u8868");
        this.friendFunsList.setId(1012);
        this.friendFunsList.setOnClickListener((View.OnClickListener)this);
        row6.addView((View)this.friendFunsList);
        table.addView((View)row6);
        TableRow row7 = new TableRow((Context)this);
        this.friendMutualList = new Button((Context)this);
        this.friendMutualList.setText((CharSequence)"\u83b7\u53d6\u4e92\u542c\u5217\u8868");
        this.friendMutualList.setId(1013);
        this.friendMutualList.setOnClickListener((View.OnClickListener)this);
        row7.addView((View)this.friendMutualList);
        this.friendCheck = new Button((Context)this);
        this.friendCheck.setText((CharSequence)"\u9a8c\u8bc1\u597d\u53cb\u5173\u7cfb");
        this.friendCheck.setId(1014);
        this.friendCheck.setOnClickListener((View.OnClickListener)this);
        row7.addView((View)this.friendCheck);
        table.addView((View)row7);
        TableRow row8 = new TableRow((Context)this);
        this.tReList = new Button((Context)this);
        this.tReList.setText((CharSequence)"\u8f6c\u64ad\u83b7\u53d6\u8f6c\u64ad\u5217\u8868");
        this.tReList.setId(1015);
        this.tReList.setOnClickListener((View.OnClickListener)this);
        row8.addView((View)this.tReList);
        this.friendGetIntimateFriend = new Button((Context)this);
        this.friendGetIntimateFriend.setText((CharSequence)"\u83b7\u53d6\u6700\u8fd1\u8054\u7cfb\u4eba");
        this.friendGetIntimateFriend.setId(1016);
        this.friendGetIntimateFriend.setOnClickListener((View.OnClickListener)this);
        row8.addView((View)this.friendGetIntimateFriend);
        table.addView((View)row8);
        TableRow row9 = new TableRow((Context)this);
        this.lbsGetAroundPeople = new Button((Context)this);
        this.lbsGetAroundPeople.setText((CharSequence)"\u83b7\u53d6\u9644\u8fd1\u7684\u4eba");
        this.lbsGetAroundPeople.setId(1017);
        this.lbsGetAroundPeople.setOnClickListener((View.OnClickListener)this);
        row9.addView((View)this.lbsGetAroundPeople);
        this.lbsGetAroundNew = new Button((Context)this);
        this.lbsGetAroundNew.setText((CharSequence)"\u83b7\u53d6\u8eab\u8fb9\u6700\u65b0\u7684\u5fae\u535a");
        this.lbsGetAroundNew.setId(1018);
        this.lbsGetAroundNew.setOnClickListener((View.OnClickListener)this);
        row9.addView((View)this.lbsGetAroundNew);
        table.addView((View)row9);
        TableRow row10 = new TableRow((Context)this);
        this.deviceStatus = new Button((Context)this);
        this.deviceStatus.setText((CharSequence)"\u7ec8\u7aef\u72b6\u51b5");
        this.deviceStatus.setId(1019);
        row10.addView((View)this.deviceStatus);
        this.errorReport = new Button((Context)this);
        this.errorReport.setText((CharSequence)"\u9519\u8bef\u53cd\u9988");
        this.errorReport.setId(1020);
        row10.addView((View)this.errorReport);
        table.addView((View)row10);
        this.scrollView.addView((View)table);
        this.setContentView((View)this.scrollView);
    }

    public void onClick(View v) {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                GeneralInterfaceActivity.this.loadingWindow.showAtLocation((View)GeneralInterfaceActivity.this.scrollView, 17, 0, 80);
                return false;
            }
        });
        switch (v.getId()) {
            case 1001: {
                this.timeLineAPI.getHomeTimeLine(this.context, 0, 0, 30, 0, 0, this.requestFormat, this.mCallBack, null, 4);
                break;
            }
            case 1002: {
                this.timeLineAPI.getUserTimeLine(this.context, 0, 0, 30, 0, "api_weibo", null, 0, 0, this.requestFormat, this.mCallBack, null, 4);
                break;
            }
            case 1003: {
                this.weiboAPI.addWeibo(this.context, "hello world !", this.requestFormat, this.longitude, this.latitude, 0, 0, this.mCallBack, null, 4);
                break;
            }
            case 1004: {
                try {
                    Bitmap bm = BitmapFactory.decodeStream((InputStream)this.context.getAssets().open("logo"));
                    this.weiboAPI.addPic(this.context, "call telephone OKK", this.requestFormat, this.longitude, this.latitude, bm, 0, 0, this.mCallBack, null, 4);
                }
                catch (Exception bm) {}
                break;
            }
            case 1005: {
                String picUrl = "http://t2.qpic.cn/mblogpic/9c7e34358608bb61a696/2000";
                this.weiboAPI.addPicUrl(this.context, "y phone ", this.requestFormat, this.longitude, this.latitude, picUrl, 0, 0, this.mCallBack, null, 4);
                break;
            }
            case 1006: {
                this.timeLineAPI.getHTTimeLine(this.context, this.requestFormat, 30, "0", "0", 0, 0, "\u52a0\u6cb9", "0", 1, 128, this.mCallBack, null, 4);
                break;
            }
            case 1007: {
                this.userAPI.getUserInfo(this.context, this.requestFormat, this.mCallBack, null, 4);
                break;
            }
            case 1008: {
                this.userAPI.getUserOtherInfo(this.context, this.requestFormat, "api_weibo", null, this.mCallBack, null, 4);
                break;
            }
            case 1009: {
                this.userAPI.getUserInfos(this.context, this.requestFormat, "api_weibo", null, this.mCallBack, null, 4);
                break;
            }
            case 1010: {
                this.friendAPI.addFriend(this.context, this.requestFormat, "api_weibo", null, this.mCallBack, null, 4);
                break;
            }
            case 1011: {
                this.friendAPI.friendIDolList(this.context, this.requestFormat, 30, 0, 1, 0, this.mCallBack, null, 4);
                break;
            }
            case 1012: {
                this.friendAPI.friendFansList(this.context, this.requestFormat, 30, 0, 1, 0, 0, this.mCallBack, null, 4);
                break;
            }
            case 1013: {
                this.friendAPI.getMutualList(this.context, this.requestFormat, "api_weibo", null, 0, 30, 0, this.mCallBack, null, 4);
                break;
            }
            case 1014: {
                this.friendAPI.friendCheck(this.context, this.requestFormat, "api_weibo", null, 2, this.mCallBack, null, 4);
                break;
            }
            case 1015: {
                this.weiboAPI.reList(this.context, this.requestFormat, 2, "112714089895346", 0, "0", 30, "0", this.mCallBack, null, 4);
                break;
            }
            case 1016: {
                this.friendAPI.getIntimateFriends(this.context, this.requestFormat, 30, this.mCallBack, null, 4);
                break;
            }
            case 1017: {
                this.lbsAPI.getAroundPeople(this.context, this.requestFormat, this.longitude, this.latitude, "", 20, 0, this.mCallBack, null, 4);
                break;
            }
            case 1018: {
                this.lbsAPI.getAroundNew(this.context, this.requestFormat, this.longitude, this.latitude, "", 20, this.mCallBack, null, 4);
                break;
            }
            case 1019: {
                break;
            }
            case 1020: {
                break;
            }
        }
    }
}

