/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.tencent.weibo.sdk.android.api.PublishWeiBoAPI;
import com.tencent.weibo.sdk.android.api.adapter.ConversationAdapter;
import com.tencent.weibo.sdk.android.api.util.BackGroudSeletor;
import com.tencent.weibo.sdk.android.api.util.Util;
import com.tencent.weibo.sdk.android.component.PublishActivity;
import com.tencent.weibo.sdk.android.model.AccountModel;
import com.tencent.weibo.sdk.android.model.ModelResult;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationActivity
extends Activity
implements HttpCallback {
    private ListView listView;
    private List<String> list;
    private EditText editText;
    private ConversationAdapter adapter;
    private ProgressDialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        LinearLayout layout = (LinearLayout)this.initview();
        this.setContentView((View)layout);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                Toast.makeText((Context)ConversationActivity.this, (CharSequence)String.valueOf(arg2), (int)100).show();
            }
        });
        if (this.dialog == null) {
            this.dialog = new ProgressDialog((Context)this);
            this.dialog.setMessage((CharSequence)"\u8bf7\u7a0d\u540e...");
            this.dialog.setCancelable(false);
        }
        this.dialog.show();
        new PublishWeiBoAPI(new AccountModel(Util.getSharePersistent((Context)this.getApplicationContext(), (String)"ACCESS_TOKEN"))).recent_used((Context)this, (HttpCallback)this, null, 15, 1, 0);
    }

    private View initview() {
        LinearLayout viewroot = new LinearLayout((Context)this);
        LinearLayout.LayoutParams params_viewroot = new LinearLayout.LayoutParams(-1, -1);
        viewroot.setLayoutParams((ViewGroup.LayoutParams)params_viewroot);
        viewroot.setOrientation(1);
        LinearLayout layout_title = new LinearLayout((Context)this);
        LinearLayout.LayoutParams params_title = new LinearLayout.LayoutParams(-1, -2);
        layout_title.setLayoutParams((ViewGroup.LayoutParams)params_title);
        layout_title.setOrientation(0);
        layout_title.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"up_bg2x", (Context)this));
        layout_title.setPadding(20, 0, 20, 0);
        layout_title.setGravity(16);
        LinearLayout layout_editext = new LinearLayout((Context)this);
        LinearLayout.LayoutParams params_editext = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        layout_editext.setLayoutParams((ViewGroup.LayoutParams)params_editext);
        layout_editext.setPadding(0, 0, 12, 0);
        this.editText = new EditText((Context)this);
        this.editText.setSingleLine(true);
        this.editText.setLines(1);
        this.editText.setTextSize(18.0f);
        this.editText.setHint((CharSequence)"\u641c\u7d22\u8bdd\u9898");
        this.editText.setPadding(20, 0, 10, 0);
        this.editText.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"huati_input2x", (Context)this));
        this.editText.setCompoundDrawablesWithIntrinsicBounds(BackGroudSeletor.getdrawble((String)"huati_icon_hover2x", (Context)this), null, null, null);
        this.editText.setLayoutParams((ViewGroup.LayoutParams)params_viewroot);
        Button button_esc = new Button((Context)this);
        String[] string_esc = new String[]{"sent_btn_22x", "sent_btn_hover"};
        button_esc.setBackgroundDrawable((Drawable)BackGroudSeletor.createBgByImageIds((String[])string_esc, (Context)this));
        button_esc.setTextColor(-1);
        button_esc.setText((CharSequence)"\u53d6\u6d88");
        layout_editext.addView((View)this.editText);
        layout_title.addView((View)layout_editext);
        layout_title.addView((View)button_esc);
        viewroot.addView((View)layout_title);
        LinearLayout layout_list = new LinearLayout((Context)this);
        LinearLayout.LayoutParams params_list = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        layout_list.setLayoutParams((ViewGroup.LayoutParams)params_list);
        this.listView = new ListView((Context)this);
        this.listView.setDivider(BackGroudSeletor.getdrawble((String)"table_lie_", (Context)this));
        this.listView.setLayoutParams((ViewGroup.LayoutParams)params_viewroot);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                ArrayList<String> lists = new ArrayList<String>();
                int i = 0;
                while (i < ConversationActivity.this.list.size()) {
                    if (((String)ConversationActivity.this.list.get(i)).contains(s.toString())) {
                        lists.add((String)ConversationActivity.this.list.get(i));
                    }
                    ++i;
                }
                ConversationActivity.this.adapter.setCvlist(lists);
                ConversationActivity.this.adapter.notifyDataSetChanged();
                ConversationActivity.this.click(lists);
            }
        });
        LinearLayout layout_foot = new LinearLayout((Context)this);
        Button button = new Button((Context)this);
        layout_foot.setGravity(17);
        button.setLayoutParams((ViewGroup.LayoutParams)params_title);
        button.setText((CharSequence)"abc");
        button.setTextColor(-16777216);
        button_esc.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationActivity.this.finish();
            }
        });
        layout_foot.addView((View)button);
        layout_list.addView((View)this.listView);
        viewroot.addView((View)layout_list);
        return viewroot;
    }

    private List<String> initData(JSONObject jsonObject) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JSONArray array = jsonObject.getJSONObject("data").getJSONArray("info");
            int i = 0;
            while (i < array.length()) {
                list.add("#" + array.getJSONObject(i).getString("text") + "#");
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void click(final List<String> li) {
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                Intent intent = new Intent();
                intent.setClass((Context)ConversationActivity.this, PublishActivity.class);
                intent.putExtra("conversation", (String)li.get(arg2));
                ConversationActivity.this.setResult(-1, intent);
                ConversationActivity.this.finish();
            }
        });
    }

    protected void onStop() {
        super.onStop();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    public void onResult(Object object) {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        if (object != null && ((ModelResult)object).isSuccess()) {
            Log.d((String)"\u53d1\u9001\u6210\u529f", (String)((ModelResult)object).getObj().toString());
            JSONObject jsonObject = (JSONObject)((ModelResult)object).getObj();
            this.list = this.initData(jsonObject);
            this.adapter = new ConversationAdapter((Context)this, this.list);
            this.listView.setAdapter((ListAdapter)this.adapter);
            this.click(this.list);
        }
    }
}

