/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.network;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ReqParam {
    private Map<String, String> mParams = new HashMap<String, String>();
    public Bitmap mBitmap = null;

    public void setBitmap(Bitmap bm) {
        this.mBitmap = bm;
    }

    public Map<String, String> getmParams() {
        return this.mParams;
    }

    public void setmParams(Map<String, String> mParams) {
        this.mParams = mParams;
    }

    public void addParam(String key, String val) {
        this.mParams.put(key, val);
    }

    public void addParam(String key, byte[] val) {
        double size = val.length / 1024;
        if (size > 400.0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            double i = size / 400.0;
            Bitmap bitmap = this.zoomImage(this.mBitmap, (double)this.mBitmap.getWidth() / Math.sqrt(i), (double)this.mBitmap.getHeight() / Math.sqrt(i));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            val = baos.toByteArray();
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < val.length) {
            buffer.append((char)val[i]);
            ++i;
        }
        Log.d((String)"buffer=======", (String)buffer.toString());
        this.mParams.put(key, buffer.toString());
    }

    public void addParam(String key, Object val) {
        this.mParams.put(key, val.toString());
    }

    public String toString() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : this.mParams.keySet()) {
            keyList.add(key);
        }
        Collections.sort(keyList, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                if (str1.compareTo(str2) > 0) {
                    return 1;
                }
                if (str1.compareTo(str2) < 0) {
                    return -1;
                }
                return 0;
            }
        });
        StringBuffer strbuf = new StringBuffer();
        for (String key : keyList) {
            if (key.equals("pic")) continue;
            strbuf.append(key);
            strbuf.append("=");
            strbuf.append(this.mParams.get(key));
            strbuf.append("&");
        }
        Log.d((String)"p-----", (String)strbuf.toString());
        String p = strbuf.toString().replaceAll("\n", "").replaceAll("\r", "");
        return p;
    }

    public Bitmap zoomImage(Bitmap bm, double newWidth, double newHeight) {
        float width = bm.getWidth();
        float height = bm.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)newWidth / width;
        float scaleHeight = (float)newHeight / height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
        return bitmap;
    }
}

