/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.network;

import com.tencent.weibo.sdk.android.network.HttpReq;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HttpService {
    private final int TAG_RUNNING = 1;
    private final int TAG_WAITTING = 0;
    private List<HttpReq> mWaitReqList = new LinkedList<HttpReq>();
    private List<HttpReq> mRunningReqList = new LinkedList<HttpReq>();
    private static HttpService instance = null;
    private int mThreadNum = 4;

    public static HttpService getInstance() {
        if (instance == null) {
            instance = new HttpService();
        }
        return instance;
    }

    private HttpService() {
    }

    public void addImmediateReq(HttpReq req) {
        req.setServiceTag(1);
        this.mRunningReqList.add(req);
        req.execute(new Void[0]);
    }

    public void addNormalReq(HttpReq req) {
        if (this.mRunningReqList.size() < this.mThreadNum) {
            req.setServiceTag(1);
            this.mRunningReqList.add(req);
            req.execute(new Void[0]);
        } else {
            req.setServiceTag(0);
            this.mWaitReqList.add(req);
        }
    }

    public void cancelReq(HttpReq req) {
        block3: {
            block2: {
                if (req.getServiceTag() != 1) break block2;
                for (HttpReq oneReq : this.mRunningReqList) {
                    if (oneReq != req) continue;
                    req.cancel(true);
                    this.mRunningReqList.remove((Object)req);
                }
                break block3;
            }
            if (req.getServiceTag() != 0) break block3;
            Iterator<HttpReq> it = this.mWaitReqList.iterator();
            while (it.hasNext()) {
                if (req != it.next()) continue;
                this.mWaitReqList.remove((Object)req);
            }
        }
    }

    public void cancelAllReq() {
        for (HttpReq oneReq : this.mRunningReqList) {
            oneReq.cancel(true);
        }
        this.mWaitReqList.clear();
    }

    public void SetAsynchronousTaskNum(int n) {
    }

    public void onReqFinish(HttpReq req) {
        HttpReq oneReq;
        boolean successDelete = false;
        Iterator<HttpReq> it = this.mRunningReqList.iterator();
        while (it.hasNext()) {
            oneReq = it.next();
            if (req != oneReq) continue;
            it.remove();
            successDelete = true;
            break;
        }
        if (this.mWaitReqList.size() > 0 && this.mRunningReqList.size() < this.mThreadNum) {
            it = this.mWaitReqList.iterator();
            oneReq = it.next();
            it.remove();
            oneReq.setServiceTag(1);
            this.mRunningReqList.add(oneReq);
            oneReq.execute(new Void[0]);
        }
    }
}

