/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.network;

import android.content.Context;
import android.util.Log;
import com.tencent.weibo.sdk.android.api.util.JsonUtil;
import com.tencent.weibo.sdk.android.model.BaseVO;
import com.tencent.weibo.sdk.android.model.ModelResult;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import com.tencent.weibo.sdk.android.network.HttpReq;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpReqWeiBo
extends HttpReq {
    private Class<? extends BaseVO> mTargetClass;
    private Class<? extends BaseVO> mTargetClass2;
    private Integer mResultType = 0;
    private Context mContext;

    public HttpReqWeiBo(Context context, String url, HttpCallback function, Class<? extends BaseVO> targetClass, String requestMethod, Integer resultType) {
        this.mContext = context;
        this.mHost = "192.168.1.100";
        this.mPort = 8088;
        this.mUrl = url;
        this.mCallBack = function;
        this.mTargetClass = targetClass;
        this.mResultType = resultType;
        this.mMethod = requestMethod;
    }

    public void setmTargetClass(Class<? extends BaseVO> mTargetClass) {
        this.mTargetClass = mTargetClass;
    }

    public void setmTargetClass2(Class<? extends BaseVO> mTargetClass2) {
        this.mTargetClass2 = mTargetClass2;
    }

    public void setmResultType(Integer mResultType) {
        this.mResultType = mResultType;
    }

    @Override
    protected Object processResponse(InputStream response) throws Exception {
        ModelResult modelResult = new ModelResult();
        if (response != null) {
            String code;
            InputStream is = response;
            InputStreamReader ireader = new InputStreamReader(is);
            BufferedReader breader = new BufferedReader(ireader);
            StringBuffer sb = new StringBuffer();
            while ((code = breader.readLine()) != null) {
                sb.append(code);
            }
            breader.close();
            ireader.close();
            Log.d((String)"relst", (String)sb.toString());
            if (sb.toString().indexOf("errcode") == -1 && sb.toString().indexOf("access_token") != -1) {
                modelResult.setObj(sb.toString());
                return modelResult;
            }
            JSONObject json = new JSONObject(sb.toString());
            BaseVO baseVO = null;
            if (this.mTargetClass != null) {
                baseVO = this.mTargetClass.newInstance();
            }
            ArrayList<BaseVO> list = null;
            Map<String, Object> map = null;
            String errorCode = json.getString("errcode");
            String msg = json.getString("msg");
            if (errorCode != null && "0".equals(errorCode)) {
                modelResult.setSuccess(true);
                switch (this.mResultType) {
                    case 0: {
                        BaseVO vo = JsonUtil.jsonToObject(this.mTargetClass, json);
                        list = new ArrayList<BaseVO>();
                        list.add(vo);
                        modelResult.setList(list);
                        break;
                    }
                    case 1: {
                        map = baseVO.analyseHead(json);
                        JSONArray array = (JSONArray)map.get("array");
                        list = JsonUtil.jsonToList(this.mTargetClass, array);
                        Integer total = map.get("total") == null ? 0 : (Integer)map.get("total");
                        Integer p = map.get("p") == null ? 1 : (Integer)map.get("p");
                        Integer ps = map.get("ps") == null ? 1 : (Integer)map.get("ps");
                        boolean isLastPage = (Boolean)map.get("isLastPage");
                        modelResult.setList(list);
                        modelResult.setTotal(total);
                        modelResult.setP(p);
                        modelResult.setPs(ps);
                        modelResult.setLastPage(isLastPage);
                        break;
                    }
                    case 2: {
                        modelResult.setObj(JsonUtil.jsonToObject(this.mTargetClass, json));
                        break;
                    }
                    case 3: {
                        BaseVO basebo = JsonUtil.jsonToObject(this.mTargetClass, json);
                        JSONArray list_json = json.getJSONArray("result_list");
                        list = JsonUtil.jsonToList(this.mTargetClass2, list_json);
                        modelResult.setObj(basebo);
                        modelResult.setList(list);
                        break;
                    }
                    case 4: {
                        modelResult.setObj(json);
                    }
                }
            } else {
                modelResult.setSuccess(false);
                modelResult.setError_message(msg);
            }
        }
        return modelResult;
    }

    @Override
    protected void setReq(HttpMethod method) throws Exception {
        if ("POST".equals(this.mMethod)) {
            PostMethod post = (PostMethod)method;
            String mParamstr = this.mParam.toString();
            post.addParameter("Connection", "Keep-Alive");
            post.addParameter("Charset", "UTF-8");
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.mParam.toString().getBytes("utf-8")));
        }
    }

    public void setReq(String url) throws Exception {
        if ("POST".equals(this.mMethod)) {
            HttpReq.UTF8PostMethod post = new HttpReq.UTF8PostMethod(this.mUrl);
            String mParamstr = this.mParam.toString();
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.mParam.toString().getBytes("utf-8")));
        }
    }
}

