/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.api;

import android.content.Context;
import android.util.Log;
import com.tencent.weibo.sdk.android.api.util.Util;
import com.tencent.weibo.sdk.android.model.AccountModel;
import com.tencent.weibo.sdk.android.model.BaseVO;
import com.tencent.weibo.sdk.android.model.ModelResult;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import com.tencent.weibo.sdk.android.network.HttpReqWeiBo;
import com.tencent.weibo.sdk.android.network.HttpService;
import com.tencent.weibo.sdk.android.network.ReqParam;

public abstract class BaseAPI {
    private AccountModel mAccount;
    private String mAccessToken;
    private HttpReqWeiBo weibo;
    private Context mContext;
    private String mRequestUrl;
    private ReqParam mParams;
    private HttpCallback mmCallBack;
    private Class<? extends BaseVO> mmTargetClass;
    private String mRequestMethod;
    private int mResultType;
    public static final String API_SERVER = "https://open.t.qq.com/api";
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String HTTPMETHOD_POST = "POST";
    public static final String HTTPMETHOD_GET = "GET";
    private HttpCallback callback = new HttpCallback(){

        @Override
        public void onResult(Object object) {
            Log.d((String)"sss", (String)("" + object));
            if (object != null) {
                ModelResult result = (ModelResult)object;
                String[] params = result.getObj().toString().split("&");
                String access_token = params[0].split("=")[1];
                BaseAPI.this.mAccessToken = access_token;
                String expires_in = params[1].split("=")[1];
                String refresh_token = params[2].split("=")[1];
                String openid = params[3].split("=")[1];
                String name = params[4].split("=")[1];
                String nick = params[5].split("=")[1];
                Util.saveSharePersistent(BaseAPI.this.mContext, "ACCESS_TOKEN", access_token);
                Util.saveSharePersistent(BaseAPI.this.mContext, "EXPIRES_IN", expires_in);
                Util.saveSharePersistent(BaseAPI.this.mContext, "OPEN_ID", openid);
                Util.saveSharePersistent(BaseAPI.this.mContext, "REFRESH_TOKEN", refresh_token);
                Util.saveSharePersistent(BaseAPI.this.mContext, "NAME", name);
                Util.saveSharePersistent(BaseAPI.this.mContext, "NICK", nick);
                Util.saveSharePersistent(BaseAPI.this.mContext, "AUTHORIZETIME", String.valueOf(System.currentTimeMillis() / 1000L));
                BaseAPI.this.weibo = new HttpReqWeiBo(BaseAPI.this.mContext, BaseAPI.this.mRequestUrl, BaseAPI.this.mmCallBack, BaseAPI.this.mmTargetClass, BaseAPI.this.mRequestMethod, BaseAPI.this.mResultType);
                BaseAPI.this.mParams.addParam("access_token", BaseAPI.this.mAccessToken);
                BaseAPI.this.weibo.setParam(BaseAPI.this.mParams);
                HttpService.getInstance().addImmediateReq(BaseAPI.this.weibo);
            }
        }
    };

    public BaseAPI(AccountModel account) {
        this.mAccount = account;
        if (this.mAccount != null) {
            this.mAccessToken = this.mAccount.getAccessToken();
        }
    }

    protected void startRequest(Context context, String requestUrl, ReqParam params, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, String requestMethod, int resultType) {
        if (this.isAuthorizeExpired(context)) {
            this.mContext = context;
            this.mRequestUrl = requestUrl;
            this.mParams = params;
            this.mmCallBack = mCallBack;
            this.mmTargetClass = mTargetClass;
            this.mRequestMethod = requestMethod;
            this.mResultType = resultType;
            String url = "https://open.t.qq.com/cgi-bin/oauth2/access_token";
            this.weibo = new HttpReqWeiBo(context, url, this.callback, null, "GET", 4);
            this.weibo.setParam(this.refreshToken(context));
            HttpService.getInstance().addImmediateReq(this.weibo);
        } else {
            this.weibo = new HttpReqWeiBo(context, requestUrl, mCallBack, mTargetClass, requestMethod, resultType);
            params.addParam("access_token", this.mAccessToken);
            this.weibo.setParam(params);
            HttpService.getInstance().addImmediateReq(this.weibo);
        }
    }

    private ReqParam refreshToken(Context context) {
        ReqParam param = new ReqParam();
        String clientId = Util.getSharePersistent(context, "CLIENT_ID");
        String refreshToken = Util.getSharePersistent(context, "REFRESH_TOKEN");
        param.addParam("client_id", clientId);
        param.addParam("grant_type", "refresh_token");
        param.addParam("refresh_token", refreshToken);
        int state = (int)Math.random() * 1000 + 111;
        param.addParam("state", state);
        return param;
    }

    public boolean isAuthorizeExpired(Context context) {
        boolean expired = false;
        String authorizeTimeStr = Util.getSharePersistent(context, "AUTHORIZETIME");
        System.out.println("===== : " + authorizeTimeStr);
        String expiresTime = Util.getSharePersistent(context, "EXPIRES_IN");
        System.out.println("====== : " + expiresTime);
        long currentTime = System.currentTimeMillis() / 1000L;
        if (expiresTime != null && authorizeTimeStr != null && Long.valueOf(authorizeTimeStr) + Long.valueOf(expiresTime) < currentTime) {
            expired = true;
        }
        return expired;
    }
}

