/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MusicObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.VideoObject;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.utils.Utility;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;

public class SinaShareContent
extends SimpleShareContent {
    private final int THUMB_LIMIT = 24576;
    private final int IMAGE_LIMIT = 153600;
    private UMImage mExtra;

    public SinaShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        }
        if (shareContent.mExtra != null) {
            this.mExtra = (UMImage)shareContent.mExtra;
        }
    }

    public WeiboMultiMessage getMessage() {
        WeiboMultiMessage weiboMessage = new WeiboMultiMessage();
        weiboMessage.textObject = this.getTextObj();
        if (this.getImage() != null) {
            weiboMessage.imageObject = this.getImageObj();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            weiboMessage.mediaObject = this.getWebpageObj();
        }
        if (this.getMusic() != null) {
            weiboMessage.mediaObject = this.getMusicObj();
            Log.d((String)"media", (String)"share music");
        }
        if (this.getVideo() != null) {
            weiboMessage.mediaObject = this.getVideoObj();
            Log.d((String)"media", (String)"share video");
        }
        return weiboMessage;
    }

    private TextObject getTextObj() {
        TextObject textObject = new TextObject();
        textObject.text = this.getText();
        return textObject;
    }

    private ImageObject getImageObj() {
        ImageObject imageObject = new ImageObject();
        if (this.getImage().asBitmap() != null) {
            byte[] datas = this.getImage().asBinImage();
            imageObject.setImageObject(BitmapFactory.decodeByteArray((byte[])datas, (int)0, (int)datas.length));
        }
        return imageObject;
    }

    private WebpageObject getWebpageObj() {
        WebpageObject mediaObject = new WebpageObject();
        mediaObject.identify = Utility.generateGUID();
        mediaObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u94fe\u63a5" : this.getTitle();
        mediaObject.description = this.getText();
        Bitmap bitmapThumb = null;
        if (this.mExtra != null) {
            byte[] datas = this.mExtra.asBinImage();
            bitmapThumb = this.mExtra.asBinImage().length > 24576 ? BitmapFactory.decodeByteArray((byte[])BitmapUtils.compressBitmap((byte[])datas, (int)24576), (int)0, (int)BitmapUtils.compressBitmap((byte[])datas, (int)24576).length) : this.mExtra.asBitmap();
        } else {
            bitmapThumb = BitmapFactory.decodeResource((Resources)ContextUtil.getContext().getResources(), (int)ResContainer.getResourceId((Context)ContextUtil.getContext(), (String)"drawable", (String)"umeng_socialize_sina"));
        }
        mediaObject.setThumbImage(bitmapThumb);
        mediaObject.actionUrl = this.getTargeturl();
        mediaObject.defaultText = this.getText();
        Log.d((String)"share", (String)("args check:" + mediaObject.checkArgs()));
        return mediaObject;
    }

    private MusicObject getMusicObj() {
        MusicObject musicObject = new MusicObject();
        musicObject.identify = Utility.generateGUID();
        musicObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u97f3\u4e50" : this.getTitle();
        musicObject.description = this.getMusic().mText;
        Bitmap bitmapThumb = null;
        if (this.getMusic().getThumbImage() != null) {
            byte[] images = BitmapUtils.compressBitmap((byte[])this.getMusic().getThumbImage().asBinImage(), (int)24576);
            if (images != null) {
                bitmapThumb = BitmapFactory.decodeByteArray((byte[])images, (int)0, (int)images.length);
            }
        } else if (!TextUtils.isEmpty((CharSequence)this.getMusic().getThumb())) {
            byte[] images = BitmapUtils.compressBitmap((byte[])new UMImage(ContextUtil.getContext(), this.getMusic().getThumb()).asBinImage(), (int)24576);
            if (images != null) {
                bitmapThumb = BitmapFactory.decodeByteArray((byte[])images, (int)0, (int)images.length);
                Log.d((String)"UM", (String)"get thumb bitmap");
            }
        } else {
            bitmapThumb = BitmapFactory.decodeResource((Resources)ContextUtil.getContext().getResources(), (int)ResContainer.getResourceId((Context)ContextUtil.getContext(), (String)"drawable", (String)"ic_logo"));
        }
        musicObject.setThumbImage(bitmapThumb);
        musicObject.actionUrl = this.getMusic().toUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getMusic().getLowBandDataUrl())) {
            musicObject.dataUrl = this.getMusic().getLowBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getMusic().getHighBandDataUrl())) {
            musicObject.dataHdUrl = this.getMusic().getHighBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getMusic().getH5Url())) {
            musicObject.h5Url = this.getMusic().getH5Url();
        }
        musicObject.duration = this.getMusic().getDuration() > 0 ? this.getMusic().getDuration() : 10;
        if (!TextUtils.isEmpty((CharSequence)this.getMusic().getDescription())) {
            musicObject.description = this.getMusic().getDescription();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            musicObject.defaultText = this.getText();
        }
        return musicObject;
    }

    private VideoObject getVideoObj() {
        VideoObject videoObject = new VideoObject();
        videoObject.identify = Utility.generateGUID();
        videoObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u89c6\u9891" : this.getTitle();
        videoObject.description = this.getText();
        Bitmap bitmapThumb = null;
        if (this.getVideo().getThumbImage() != null) {
            byte[] images = BitmapUtils.compressBitmap((byte[])this.getVideo().getThumbImage().asBinImage(), (int)24576);
            if (images != null) {
                bitmapThumb = BitmapFactory.decodeByteArray((byte[])images, (int)0, (int)images.length);
            }
        } else if (!TextUtils.isEmpty((CharSequence)this.getVideo().getThumb())) {
            byte[] images = new UMImage(ContextUtil.getContext(), this.getVideo().getThumb()).asBinImage();
            if (images != null) {
                bitmapThumb = BitmapFactory.decodeByteArray((byte[])images, (int)0, (int)images.length);
            }
        } else {
            bitmapThumb = BitmapFactory.decodeResource((Resources)ContextUtil.getContext().getResources(), (int)ResContainer.getResourceId((Context)ContextUtil.getContext(), (String)"drawable", (String)"ic_logo"));
        }
        videoObject.setThumbImage(bitmapThumb);
        videoObject.actionUrl = this.getVideo().toUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getLowBandDataUrl())) {
            videoObject.dataUrl = this.getVideo().getLowBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getHighBandDataUrl())) {
            videoObject.dataHdUrl = this.getVideo().getHighBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getH5Url())) {
            videoObject.h5Url = this.getVideo().getH5Url();
        }
        videoObject.duration = this.getVideo().getDuration() > 0 ? this.getVideo().getDuration() : 10;
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getDescription())) {
            videoObject.description = this.getVideo().getDescription();
        }
        videoObject.defaultText = "Video \u5206\u4eab\u89c6\u9891";
        return videoObject;
    }

    private VoiceObject getVoiceObj() {
        return null;
    }
}

