/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;

public class SinaPreferences {
    private static final String KEY_ACCESS_KEY = "access_key";
    private static final String KEY_ACCESS_SECRET = "access_secret";
    private static final String KEY_UID = "uid";
    private static final String KEY_TTL = "expires_in";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_SSO_TTL = "expires_in";
    private static final String KEY_USER_NAME = "userName";
    private static final String KEY_SSO_UID = "uid";
    private static final String FOLLOW = "isfollow";
    private String mAccessKey = null;
    private String mAccessSecret = null;
    private String mUID = null;
    private long mTTL = 0L;
    private String mAccessToken = null;
    private String mRefreshToken = null;
    private String mUserName = null;
    private boolean isfollow = false;
    private SharedPreferences sharedPreferences = null;

    public SinaPreferences(Context context, String platform) {
        this.sharedPreferences = context.getSharedPreferences(platform, 0);
        this.mAccessKey = this.sharedPreferences.getString(KEY_ACCESS_KEY, null);
        this.mRefreshToken = this.sharedPreferences.getString(KEY_REFRESH_TOKEN, null);
        this.mAccessSecret = this.sharedPreferences.getString(KEY_ACCESS_SECRET, null);
        this.mAccessToken = this.sharedPreferences.getString(KEY_ACCESS_TOKEN, null);
        this.mUID = this.sharedPreferences.getString("uid", null);
        this.mTTL = this.sharedPreferences.getLong("expires_in", 0L);
        this.isfollow = this.sharedPreferences.getBoolean(FOLLOW, false);
    }

    public SinaPreferences setAuthData(Map<String, String> data) {
        this.mAccessKey = data.get(KEY_ACCESS_KEY);
        this.mAccessSecret = data.get(KEY_ACCESS_SECRET);
        this.mAccessToken = data.get(KEY_ACCESS_TOKEN);
        this.mRefreshToken = data.get(KEY_REFRESH_TOKEN);
        this.mUID = data.get("uid");
        if (!TextUtils.isEmpty((CharSequence)data.get("expires_in"))) {
            this.mTTL = Long.valueOf(data.get("expires_in")) * 1000L + System.currentTimeMillis();
        }
        return this;
    }

    public String getmAccessToken() {
        return this.mAccessToken;
    }

    public long getmTTL() {
        return this.mTTL;
    }

    public String getmRefreshToken() {
        return this.mRefreshToken;
    }

    public SinaPreferences setAuthData(Bundle bundle) {
        this.mAccessToken = bundle.getString(KEY_ACCESS_TOKEN);
        this.mRefreshToken = bundle.getString(KEY_REFRESH_TOKEN);
        this.mUID = bundle.getString("uid");
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("expires_in"))) {
            this.mTTL = Long.valueOf(bundle.getString("expires_in")) * 1000L + System.currentTimeMillis();
        }
        return this;
    }

    public Map<String, String> getAuthData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_ACCESS_KEY, this.mAccessKey);
        map.put(KEY_ACCESS_SECRET, this.mAccessSecret);
        map.put("uid", this.mUID);
        map.put("expires_in", String.valueOf(this.mTTL));
        return map;
    }

    public String getUID() {
        return this.mUID;
    }

    public boolean isAuthorized() {
        return !TextUtils.isEmpty((CharSequence)this.mAccessToken);
    }

    public boolean isAuthValid() {
        boolean isAuthorized = this.isAuthorized();
        boolean isExpired = this.mTTL - System.currentTimeMillis() <= 0L;
        return isAuthorized && !isExpired;
    }

    public boolean Isfollow() {
        return this.isfollow;
    }

    public void setIsfollow(boolean isfollow) {
        this.sharedPreferences.edit().putBoolean(FOLLOW, isfollow).commit();
    }

    public void commit() {
        this.sharedPreferences.edit().putString(KEY_ACCESS_KEY, this.mAccessKey).putString(KEY_ACCESS_SECRET, this.mAccessSecret).putString(KEY_ACCESS_TOKEN, this.mAccessToken).putString(KEY_REFRESH_TOKEN, this.mRefreshToken).putString("uid", this.mUID).putLong("expires_in", this.mTTL).commit();
        Log.i((String)"save auth succeed");
    }

    public void delete() {
        this.mAccessKey = null;
        this.mAccessSecret = null;
        this.mAccessToken = null;
        this.mUID = null;
        this.mTTL = 0L;
        this.sharedPreferences.edit().clear().commit();
    }
}

