/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.UResponse;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;

public class ResUtil {
    private static final String TAG = "ResUtil";
    public static boolean RESUTIL_DEBUG = false;
    private static final long EXTERNAL_CACHE_SIZE = 0x6400000L;
    private static final long INTERNAL_CACHE_SIZE = 0xA00000L;
    private static final Map<ImageView, String> IMAGE_VIEWS = Collections.synchronizedMap(new WeakHashMap());

    private static String getMd5FileName(String string) {
        return AesHelper.md5(string);
    }

    public static String getResource(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        File file = null;
        try {
            int n;
            long l;
            String string2;
            String string3 = ResUtil.getMd5FileName(string) + ".tmp";
            if (DeviceConfig.isSdCardWrittenable()) {
                string2 = Environment.getExternalStorageDirectory().getCanonicalPath();
                l = 0x6400000L;
            } else {
                string2 = context.getCacheDir().getCanonicalPath();
                l = 0xA00000L;
            }
            final File file2 = new File(string2 + "/download/.um");
            if (file2.exists()) {
                if (ResUtil.dirSize(file2.getCanonicalFile()) > l) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ResUtil.cleanDir(file2);
                        }
                    }).start();
                }
            } else if (!file2.mkdirs()) {
                Log.e(TAG, "Failed to create directory" + file2.getAbsolutePath() + ". Check permission. Make sure WRITE_EXTERNAL_STORAGE is added in your Manifest.xml");
            }
            file = new File(file2, string3);
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = (InputStream)new URL(string).openConnection().getContent();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            inputStream.close();
            fileOutputStream.close();
            File file3 = new File(file.getParent(), file.getName().replace(".tmp", ""));
            file.renameTo(file3);
            Log.i(TAG, "download img[" + string + "]  to " + file3.getCanonicalPath());
            return file3.getCanonicalPath();
        }
        catch (Exception exception) {
            Log.i(TAG, exception.getStackTrace().toString() + "\t url:\t" + string);
            if (file != null && file.exists()) {
                file.deleteOnExit();
            }
            return null;
        }
    }

    private static long dirSize(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return 0L;
        }
        long l = 0L;
        Stack<File> stack = new Stack<File>();
        stack.clear();
        stack.push(file);
        while (!stack.isEmpty()) {
            File file2 = (File)stack.pop();
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    stack.push(fileArray[i]);
                    continue;
                }
                l += fileArray[i].length();
            }
        }
        return l;
    }

    private static void cleanDir(File file) {
        if (!(file != null && file.exists() && file.canWrite() && file.isDirectory())) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                ResUtil.cleanDir(fileArray[i]);
                continue;
            }
            if (new Date().getTime() - fileArray[i].lastModified() <= 1800L) continue;
            fileArray[i].delete();
        }
    }

    protected static File getCachedFile(Context context, String string) throws IOException {
        String string2 = ResUtil.getMd5FileName(string);
        String string3 = DeviceConfig.isSdCardWrittenable() ? Environment.getExternalStorageDirectory().getCanonicalPath() : context.getCacheDir().getCanonicalPath();
        File file = new File(string3 + "/download/.um");
        File file2 = new File(file, string2);
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    public static void bindDrawable(Context context, ImageView imageView, String string, boolean bl, BindDrawableListener bindDrawableListener, Animation animation) {
        block7: {
            if (imageView == null) {
                return;
            }
            IMAGE_VIEWS.put(imageView, string);
            try {
                File file = ResUtil.getCachedFile(context, string);
                if (file != null && file.exists() && !RESUTIL_DEBUG) {
                    Drawable drawable;
                    if (bindDrawableListener != null) {
                        bindDrawableListener.onStart(BindMode.BIND_FORM_CACHE);
                    }
                    if ((drawable = ResUtil.createFromPathBuffer(file.getAbsolutePath())) == null) {
                        file.delete();
                    }
                    ResUtil.doBind(context, imageView, drawable, bl, bindDrawableListener, animation, string);
                } else {
                    FetchTask fetchTask = new FetchTask(context, imageView, string, BindMode.BIND_FROM_NET, null, bl, bindDrawableListener, animation);
                    fetchTask.execute(new Object[0]);
                }
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
                if (bindDrawableListener == null) break block7;
                bindDrawableListener.onEnd(UResponse.STATUS.FAIL);
            }
        }
    }

    private static boolean imageViewReused(ImageView imageView, String string) {
        String string2 = IMAGE_VIEWS.get(imageView);
        return string2 != null && !string2.equals(string);
    }

    private static synchronized void doBind(Context context, ImageView imageView, Drawable drawable, boolean bl, BindDrawableListener bindDrawableListener, Animation animation, String string) {
        block11: {
            try {
                if (drawable != null) {
                    Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
                    Bitmap bitmap2 = ResUtil.getRoundedCornerBitmap(bitmap);
                    drawable = new BitmapDrawable(bitmap2);
                }
                if (drawable == null || imageView == null) {
                    if (bindDrawableListener != null) {
                        bindDrawableListener.onEnd(UResponse.STATUS.FAIL);
                    }
                    Log.w(TAG, "bind drawable failed. drawable [" + drawable + "]  imageView[+" + imageView + "+]");
                    return;
                }
                if (ResUtil.imageViewReused(imageView, string)) {
                    if (bindDrawableListener != null) {
                        bindDrawableListener.onEnd(UResponse.STATUS.FAIL);
                    }
                    return;
                }
                if (bl) {
                    imageView.setBackgroundDrawable(drawable);
                } else {
                    imageView.setImageDrawable(drawable);
                }
                if (animation != null) {
                    imageView.startAnimation(animation);
                }
                if (bindDrawableListener != null) {
                    bindDrawableListener.onEnd(UResponse.STATUS.SUCCESS);
                }
            }
            catch (Exception exception) {
                Log.e(TAG, "bind failed", exception);
                if (bindDrawableListener == null) break block11;
                bindDrawableListener.onEnd(UResponse.STATUS.FAIL);
            }
        }
    }

    private static Drawable createFromPathBuffer(String string) {
        Drawable drawable = null;
        try {
            drawable = Drawable.createFromPath((String)string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.w(TAG, "Resutil fetchImage OutOfMemoryError:" + outOfMemoryError.toString());
        }
        return drawable;
    }

    private static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            int n = -12434878;
            Paint paint = new Paint();
            Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF = new RectF(rect);
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-12434878);
            canvas.drawRoundRect(rectF, (float)(bitmap.getWidth() / 6), (float)(bitmap.getHeight() / 6), paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            canvas.drawBitmap(bitmap, rect, rect, paint);
            bitmap.recycle();
            return bitmap2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.w(TAG, "Cant`t create round corner bitmap. [OutOfMemoryError] ");
            return null;
        }
    }

    public static enum BindMode {
        BIND_FORM_CACHE,
        BIND_FROM_NET;

    }

    public static interface BindDrawableListener {
        public void onStart(BindMode var1);

        public void onEnd(UResponse.STATUS var1);
    }

    static class FetchTask
    extends AsyncTask<Object, Integer, Drawable> {
        private Context mContext;
        private String mUrl;
        private ImageView mImageView;
        private BindMode mMode;
        private boolean isBackground;
        private BindDrawableListener mBindListener;
        private Animation mBindAnim;
        private File mCacheFile;

        public FetchTask(Context context, ImageView imageView, String string, BindMode bindMode, File file, boolean bl, BindDrawableListener bindDrawableListener, Animation animation) {
            this.mCacheFile = file;
            this.mContext = context;
            this.mUrl = string;
            this.mBindListener = bindDrawableListener;
            this.mMode = bindMode;
            this.isBackground = bl;
            this.mBindAnim = animation;
            this.mImageView = imageView;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.mBindListener != null) {
                this.mBindListener.onStart(this.mMode);
            }
        }

        protected void onPostExecute(Drawable drawable) {
            ResUtil.doBind(this.mContext, this.mImageView, drawable, this.isBackground, this.mBindListener, this.mBindAnim, this.mUrl);
        }

        protected Drawable doInBackground(Object ... objectArray) {
            if (RESUTIL_DEBUG) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.mCacheFile != null && this.mCacheFile.exists()) {
                Drawable drawable = ResUtil.createFromPathBuffer(this.mCacheFile.getAbsolutePath());
                if (drawable == null) {
                    this.mCacheFile.delete();
                }
                Log.d(ResUtil.TAG, "get drawable from cacheFile.");
                return drawable;
            }
            try {
                ResUtil.getResource(this.mContext, this.mUrl);
                File file = null;
                Drawable drawable = null;
                file = ResUtil.getCachedFile(this.mContext, this.mUrl);
                if (file != null && file.exists()) {
                    drawable = ResUtil.createFromPathBuffer(file.getAbsolutePath());
                }
                Log.d(ResUtil.TAG, "get drawable from net else file.");
                return drawable;
            }
            catch (Exception exception) {
                Log.w(ResUtil.TAG, exception.toString(), exception);
                return null;
            }
        }
    }
}

