/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.umeng.socialize.utils.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;

public class DeviceConfig {
    protected static final String LOG_TAG = "DeviceConfig";
    protected static final String UNKNOW = "Unknown";
    private static final String MOBILE_NETWORK = "2G/3G";
    private static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    public static final boolean isAndroidM = false;
    public static Context context;

    public static boolean isAppInstalled(String string, Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        boolean bl = false;
        try {
            packageManager.getPackageInfo(string, 1);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static String getAppVersion(String string, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            String string2 = packageInfo.versionName;
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isChinese(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return locale.toString().equals(Locale.CHINA.toString());
    }

    public static boolean checkPermission(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(string, context.getPackageName()) == 0;
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            Log.w(LOG_TAG, "No IMEI.");
        }
        String string = "";
        try {
            if (DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                string = telephonyManager.getDeviceId();
            }
        }
        catch (Exception exception) {
            Log.w(LOG_TAG, "No IMEI.", exception);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w(LOG_TAG, "No IMEI.");
            string = DeviceConfig.getMac(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                Log.w(LOG_TAG, "Failed to take mac as IMEI. Try to use Secure.ANDROID_ID instead.");
                string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                Log.w(LOG_TAG, "getDeviceId: Secure.ANDROID_ID: " + string);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfig.getDeviceSN();
                    return string;
                }
            }
        }
        return string;
    }

    public static String getDeviceSN() {
        String string = null;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            string = (String)method.invoke(clazz, "ro.serialno", "unknown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
            stringArray[0] = UNKNOW;
            return stringArray;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            stringArray[0] = UNKNOW;
            return stringArray;
        }
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo.getState() == NetworkInfo.State.CONNECTED) {
            stringArray[0] = WIFI;
            return stringArray;
        }
        NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
        if (networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
            stringArray[0] = MOBILE_NETWORK;
            stringArray[1] = networkInfo2.getSubtypeName();
            return stringArray;
        }
        return stringArray;
    }

    public static boolean isWiFiAvailable(Context context) {
        return WIFI.equals(DeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        return DeviceConfig.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && DeviceConfig.isOnline(context);
    }

    public static boolean isSdCardWrittenable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getAndroidID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getMac(Context context) {
        String string = "";
        try {
            string = DeviceConfig.getMacShell();
            if (TextUtils.isEmpty((CharSequence)string)) {
                Log.w(LOG_TAG, "Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            Log.w(LOG_TAG, "Could not get mac address." + exception.toString());
            return string;
        }
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    private static String getMacShell() {
        String[] stringArray = new String[]{"/sys/class/net/wlan0/address", "/sys/class/net/eth0/address", "/sys/devices/virtual/net/wlan0/address"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = DeviceConfig.reaMac(stringArray[i]);
                if (string == null) continue;
                return string;
            }
            catch (Exception exception) {
                Log.e(LOG_TAG, "open file  Failed", exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reaMac(String string) throws FileNotFoundException {
        String string2 = null;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = null;
        if (fileReader != null) {
            try {
                bufferedReader = new BufferedReader(fileReader, 1024);
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                Log.e(LOG_TAG, "Could not read from file " + string, iOException);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return string2;
    }
}

