/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.net.Uri;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.net.utils.UResponse;
import com.umeng.socialize.utils.Log;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UClient {
    private static final String TAG = "UClient";
    private Map<String, String> mHeaders;
    private StringBuilder mRequestInfo;
    private static final String END = "\r\n";

    public <T extends UResponse> T execute(URequest uRequest, Class<T> clazz) {
        uRequest.onPrepareRequest();
        String string = uRequest.getHttpMethod().trim();
        this.verifyMethod(string);
        this.mRequestInfo = new StringBuilder();
        JSONObject jSONObject = null;
        if (URequest.GET.equals(string)) {
            jSONObject = this.httpGetRequest(uRequest);
        } else if (URequest.POST.equals(string)) {
            jSONObject = this.httpPostRequest(uRequest.mBaseUrl, uRequest);
        }
        if (jSONObject == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(JSONObject.class);
            return (T)((UResponse)constructor.newInstance(jSONObject));
        }
        catch (SecurityException securityException) {
            Log.e(TAG, "SecurityException", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e(TAG, "NoSuchMethodException", noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "IllegalArgumentException", illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            Log.e(TAG, "InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e(TAG, "IllegalAccessException", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e(TAG, "InvocationTargetException", invocationTargetException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject httpPostRequest(String string, URequest uRequest) {
        String string2 = uRequest.toJson() == null ? "" : uRequest.toJson().toString();
        int n = new Random().nextInt(1000);
        Object object = System.getProperty("line.separator");
        Log.i(TAG, n + "post request:" + string + (String)object + string2);
        String string3 = UUID.randomUUID().toString();
        object = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            String string4;
            Object object2;
            object = this.openUrlConnection(uRequest);
            if (object == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            Map<String, Object> map = uRequest.getBodyPair();
            if (map != null && map.size() > 0) {
                ((URLConnection)object).setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
                outputStream = ((URLConnection)object).getOutputStream();
                this.addBodyParams(uRequest, outputStream, string3);
            } else {
                ((URLConnection)object).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                object2 = new Uri.Builder();
                object2.appendQueryParameter("content", string2);
                string4 = object2.build().getEncodedQuery();
                outputStream = new DataOutputStream(((URLConnection)object).getOutputStream());
                outputStream.write(string4.getBytes());
            }
            outputStream.flush();
            if (((HttpURLConnection)object).getResponseCode() == 200) {
                inputStream = ((URLConnection)object).getInputStream();
                object2 = ((URLConnection)object).getContentEncoding();
                string4 = this.parseResult(((HttpURLConnection)object).getRequestMethod(), (String)object2, inputStream);
                Log.d(TAG, "requestMethod:POST;json data:" + string4);
                String string5 = string4;
                this.closeQuietly(inputStream);
                this.closeQuietly(outputStream);
                if (object != null) {
                    ((HttpURLConnection)object).disconnect();
                }
                return string5;
            }
            object2 = null;
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (object != null) {
                ((HttpURLConnection)object).disconnect();
            }
            return object2;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught Exception in httpPostRequest()", iOException);
        }
        finally {
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (object != null) {
                ((HttpURLConnection)object).disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject httpGetRequest(URequest uRequest) {
        JSONObject jSONObject;
        HttpURLConnection httpURLConnection;
        InputStream inputStream;
        block13: {
            JSONObject jSONObject2;
            block12: {
                String string = uRequest.toGetUrl();
                inputStream = null;
                httpURLConnection = null;
                try {
                    if (string.length() <= 1) {
                        int n = new Random().nextInt(1000);
                        Log.e(TAG, n + "get request:Invalid baseUrl.");
                        JSONObject jSONObject3 = null;
                        this.closeQuietly(inputStream);
                        if (httpURLConnection == null) return jSONObject3;
                        httpURLConnection.disconnect();
                        return jSONObject3;
                    }
                    httpURLConnection = this.openUrlConnection(uRequest);
                    if (httpURLConnection == null) {
                        JSONObject jSONObject4 = null;
                        return jSONObject4;
                    }
                    if (httpURLConnection.getResponseCode() == 200) {
                        inputStream = httpURLConnection.getInputStream();
                        String string2 = httpURLConnection.getContentEncoding();
                        JSONObject jSONObject5 = this.parseResult(httpURLConnection.getRequestMethod(), string2, inputStream);
                        Log.d(TAG, "requestMethod:GET;json data:" + jSONObject5);
                        jSONObject2 = jSONObject5;
                        this.closeQuietly(inputStream);
                        break block12;
                    }
                    jSONObject = null;
                    this.closeQuietly(inputStream);
                    break block13;
                }
                catch (Exception exception) {
                    Log.e(TAG, "Caught Exception in httpGetRequest()", exception);
                    return null;
                }
            }
            if (httpURLConnection == null) return jSONObject2;
            httpURLConnection.disconnect();
            return jSONObject2;
        }
        if (httpURLConnection == null) return jSONObject;
        httpURLConnection.disconnect();
        return jSONObject;
        finally {
            this.closeQuietly(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private HttpURLConnection openUrlConnection(URequest uRequest) throws IOException {
        String string = uRequest.getHttpMethod().trim();
        String string2 = null;
        if (URequest.GET.equals(string)) {
            string2 = uRequest.toGetUrl();
        } else if (URequest.POST.equals(string)) {
            string2 = uRequest.mBaseUrl;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        URL uRL = new URL(string2);
        String string3 = uRL.getProtocol();
        boolean bl = false;
        if ("https".equals(string3)) {
            bl = true;
        }
        HttpURLConnection httpURLConnection = bl ? (HttpsURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(Config.connectionTimeOut);
        httpURLConnection.setReadTimeout(Config.readSocketTimeOut);
        httpURLConnection.setRequestMethod(string);
        if (URequest.GET.equals(string)) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (this.mHeaders != null && this.mHeaders.size() > 0) {
                Set<String> set = this.mHeaders.keySet();
                for (String string4 : set) {
                    httpURLConnection.setRequestProperty(string4, this.mHeaders.get(string4));
                }
            }
        } else if (URequest.POST.equals(string)) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
        }
        return httpURLConnection;
    }

    public UClient setHeader(Map<String, String> map) {
        this.mHeaders = map;
        return this;
    }

    private void outprint(String string) {
        this.mRequestInfo.append(string);
    }

    private void verifyMethod(String string) {
        String string2 = string;
        if (TextUtils.isEmpty((CharSequence)string2) || !(URequest.GET.equals(string2.trim()) ^ URequest.POST.equals(string2.trim()))) {
            throw new RuntimeException("\u9a8c\u8bc1\u8bf7\u6c42\u65b9\u5f0f\u5931\u8d25[" + string2 + "]");
        }
    }

    private void addBodyParams(URequest uRequest, OutputStream outputStream, String string) throws IOException {
        Object object;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> map = uRequest.getBodyPair();
        Set<String> set = map.keySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (map.get(object) == null) continue;
            this.addFormField(stringBuilder, (String)object, map.get(object).toString(), string);
        }
        if (stringBuilder.length() > 0) {
            bl = true;
            outputStream = new DataOutputStream(outputStream);
            outputStream.write(stringBuilder.toString().getBytes());
        }
        if ((object2 = uRequest.getFilePair()) != null && object2.size() > 0) {
            object = object2.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                URequest.FilePair filePair = (URequest.FilePair)object2.get(string2);
                byte[] byArray = filePair.mBinaryData;
                if (byArray == null || byArray.length < 1) continue;
                bl = true;
                this.addFilePart(filePair.mFileName, byArray, string, outputStream);
            }
        }
        if (bl) {
            this.finishWrite(outputStream, string);
        }
    }

    private void addFormField(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("--").append(string3).append(END).append("Content-Disposition: form-data; name=\"").append(string).append("\"").append(END).append("Content-Type: text/plain; charset=").append("UTF-8").append(END).append(END).append(string2).append(END);
    }

    private void addFilePart(String string, byte[] byArray, String string2, OutputStream outputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--").append(string2).append(END).append("Content-Disposition: form-data; name=\"").append(string).append("\"; filename=\"").append(string).append("\"").append(END).append("Content-Type: ").append("application/octet-stream").append(END).append("Content-Transfer-Encoding: binary").append(END).append(END);
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.write(byArray);
        outputStream.write(END.getBytes());
    }

    private void finishWrite(OutputStream outputStream, String string) throws IOException {
        outputStream.write(END.getBytes());
        outputStream.write(("--" + string + "--").getBytes());
        outputStream.write(END.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected JSONObject parseResult(String string, String string2, InputStream inputStream) {
        block11: {
            InputStream inputStream2 = null;
            try {
                inputStream2 = this.wrapStream(string2, inputStream);
                String string3 = this.convertStreamToString(inputStream2);
                Log.d(TAG, "requestMethod:" + string + ";origin data:" + string3);
                if ("POST".equals(string)) {
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        return jSONObject;
                    }
                    catch (Exception exception) {
                        JSONObject jSONObject = this.decryptData(string3);
                        this.closeQuietly(inputStream2);
                        return jSONObject;
                    }
                }
                if ("GET".equals(string)) {
                    JSONObject jSONObject = this.decryptData(string3);
                    return jSONObject;
                }
                break block11;
                {
                    catch (IOException iOException) {
                        Log.e(TAG, "Caught IOException in parseResult()", iOException);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeQuietly(inputStream2);
            }
        }
        return null;
    }

    protected InputStream wrapStream(String string, InputStream inputStream) throws IOException {
        if (string == null || "identity".equalsIgnoreCase(string)) {
            return inputStream;
        }
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream, new Inflater(false), 512);
        }
        throw new RuntimeException("unsupported content-encoding: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertStreamToString(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 512);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught IOException in convertStreamToString()", iOException);
            String string = null;
            return string;
        }
        finally {
            this.closeQuietly(inputStreamReader);
            this.closeQuietly(bufferedReader);
        }
        return stringBuilder.toString();
    }

    private JSONObject decryptData(String string) {
        try {
            String string2 = AesHelper.decryptNoPadding(string, "UTF-8").trim();
            return new JSONObject(string2);
        }
        catch (Exception exception) {
            Log.e(TAG, "Caught Exception in decryptData()", exception);
            return null;
        }
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught IOException in closeQuietly()", iOException);
        }
    }
}

