/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class LegacyNativeDialogParameters {
    public static Bundle create(UUID callId, ShareContent shareContent, boolean shouldFailOnDataError) {
        Bundle nativeParams = null;
        if (shareContent instanceof ShareLinkContent) {
            ShareLinkContent linkContent = (ShareLinkContent)shareContent;
            nativeParams = LegacyNativeDialogParameters.create(linkContent, shouldFailOnDataError);
        } else if (shareContent instanceof SharePhotoContent) {
            SharePhotoContent photoContent = (SharePhotoContent)shareContent;
            List<String> photoUrls = ShareInternalUtility.getPhotoUrls(photoContent, callId);
            nativeParams = LegacyNativeDialogParameters.create(photoContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent instanceof ShareVideoContent) {
            ShareVideoContent videoContent = (ShareVideoContent)shareContent;
            nativeParams = LegacyNativeDialogParameters.create(videoContent, shouldFailOnDataError);
        } else if (shareContent instanceof ShareOpenGraphContent) {
            ShareOpenGraphContent openGraphContent = (ShareOpenGraphContent)shareContent;
            ShareOpenGraphAction action = openGraphContent.getAction();
            try {
                JSONObject openGraphActionJSON = ShareInternalUtility.toJSONObjectForCall(callId, action);
                nativeParams = LegacyNativeDialogParameters.create(openGraphContent, openGraphActionJSON, shouldFailOnDataError);
            }
            catch (JSONException e) {
                throw new FacebookException("Unable to create a JSON Object from the provided ShareOpenGraphContent: " + e.getMessage());
            }
        }
        return nativeParams;
    }

    private static Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(linkContent, dataErrorsFatal);
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.TITLE", linkContent.getContentTitle());
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.DESCRIPTION", linkContent.getContentDescription());
        Utility.putUri(params, "com.facebook.platform.extra.IMAGE", linkContent.getImageUrl());
        return params;
    }

    private static Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("com.facebook.platform.extra.PHOTOS", new ArrayList<String>(imageUrls));
        return params;
    }

    private static Bundle create(ShareVideoContent videoContent, boolean dataErrorsFatal) {
        return null;
    }

    private static Bundle create(ShareOpenGraphContent openGraphContent, JSONObject openGraphActionJSON, boolean dataErrorsFatal) {
        Bundle params = LegacyNativeDialogParameters.createBaseParameters(openGraphContent, dataErrorsFatal);
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.PREVIEW_PROPERTY_NAME", openGraphContent.getPreviewPropertyName());
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.ACTION_TYPE", openGraphContent.getAction().getActionType());
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.ACTION", openGraphActionJSON.toString());
        return params;
    }

    private static Bundle createBaseParameters(ShareContent content, boolean dataErrorsFatal) {
        Bundle params = new Bundle();
        Utility.putUri(params, "com.facebook.platform.extra.LINK", content.getContentUrl());
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.PLACE", content.getPlaceId());
        Utility.putNonEmptyString(params, "com.facebook.platform.extra.REF", content.getRef());
        params.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        if (!Utility.isNullOrEmpty(peopleIds)) {
            params.putStringArrayList("com.facebook.platform.extra.FRIENDS", new ArrayList<String>(peopleIds));
        }
        return params;
    }
}

