/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.TargetApi;
import android.content.SharedPreferences;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import org.json.JSONException;
import org.json.JSONObject;

final class ProfileCache {
    static final String CACHED_PROFILE_KEY = "com.facebook.ProfileManager.CachedProfile";
    static final String SHARED_PREFERENCES_NAME = "com.facebook.AccessTokenManager.SharedPreferences";
    private final SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.AccessTokenManager.SharedPreferences", 0);

    ProfileCache() {
    }

    Profile load() {
        String jsonString = this.sharedPreferences.getString(CACHED_PROFILE_KEY, null);
        if (jsonString != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                return new Profile(jsonObject);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @TargetApi(value=9)
    void save(Profile profile) {
        JSONObject jsonObject = profile.toJSONObject();
        if (jsonObject != null) {
            this.sharedPreferences.edit().putString(CACHED_PROFILE_KEY, jsonObject.toString()).apply();
        }
    }

    @TargetApi(value=9)
    void clear() {
        this.sharedPreferences.edit().remove(CACHED_PROFILE_KEY).apply();
    }
}

