/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.concurrent.Executor;

public class GraphRequestAsyncTask
extends AsyncTask<Void, Void, List<GraphResponse>> {
    private static final String TAG = GraphRequestAsyncTask.class.getCanonicalName();
    private static Method executeOnExecutorMethod;
    private final HttpURLConnection connection;
    private final GraphRequestBatch requests;
    private Exception exception;

    public GraphRequestAsyncTask(GraphRequestBatch requests) {
        this(null, requests);
    }

    public GraphRequestAsyncTask(HttpURLConnection connection, GraphRequest ... requests) {
        this(connection, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(HttpURLConnection connection, GraphRequestBatch requests) {
        this.requests = requests;
        this.connection = connection;
    }

    protected final Exception getException() {
        return this.exception;
    }

    protected final GraphRequestBatch getRequests() {
        return this.requests;
    }

    public String toString() {
        return "{RequestAsyncTask: " + " connection: " + this.connection + ", requests: " + this.requests + "}";
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.requests.getCallbackHandler() == null) {
            this.requests.setCallbackHandler(new Handler());
        }
    }

    protected void onPostExecute(List<GraphResponse> result) {
        super.onPostExecute(result);
        if (this.exception != null) {
            Log.d((String)TAG, (String)String.format("onPostExecute: exception encountered during request: %s", this.exception.getMessage()));
        }
    }

    protected List<GraphResponse> doInBackground(Void ... params) {
        try {
            if (this.connection == null) {
                return this.requests.executeAndWait();
            }
            return GraphRequest.executeConnectionAndWait(this.connection, this.requests);
        }
        catch (Exception e) {
            this.exception = e;
            return null;
        }
    }

    GraphRequestAsyncTask executeOnSettingsExecutor() {
        if (executeOnExecutorMethod != null) {
            try {
                executeOnExecutorMethod.invoke((Object)this, FacebookSdk.getExecutor(), null);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            this.execute(new Void[0]);
        }
        return this;
    }

    static {
        for (Method method : AsyncTask.class.getMethods()) {
            Class<?>[] parameters;
            if (!"executeOnExecutor".equals(method.getName()) || (parameters = method.getParameterTypes()).length != 2 || parameters[0] != Executor.class || !parameters[1].isArray()) continue;
            executeOnExecutorMethod = method;
            break;
        }
    }
}

