/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.AsyncTask;
import android.util.Base64;
import com.facebook.AccessToken;
import com.facebook.AccessTokenManager;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.Profile;
import com.facebook.ProfileManager;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import java.io.File;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class FacebookSdk {
    private static final String TAG = FacebookSdk.class.getCanonicalName();
    private static final HashSet<LoggingBehavior> loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(LoggingBehavior.DEVELOPER_ERRORS));
    private static volatile Executor executor;
    private static volatile String applicationId;
    private static volatile String applicationName;
    private static volatile String appClientToken;
    private static final String FACEBOOK_COM = "facebook.com";
    private static volatile String facebookDomain;
    private static AtomicLong onProgressThreshold;
    private static volatile boolean isDebugEnabled;
    private static boolean isLegacyTokenUpgradeSupported;
    private static File cacheDir;
    private static Context applicationContext;
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 128;
    private static final int DEFAULT_KEEP_ALIVE = 1;
    private static int callbackRequestCodeOffset;
    private static final Object LOCK;
    private static final int MAX_REQUEST_CODE_RANGE = 100;
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    private static final BlockingQueue<Runnable> DEFAULT_WORK_QUEUE;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY;
    static final String CALLBACK_OFFSET_CHANGED_AFTER_INIT = "The callback request code offset can't be updated once the SDK is initialized.";
    static final String CALLBACK_OFFSET_NEGATIVE = "The callback request code offset can't be negative.";
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    public static final String APPLICATION_NAME_PROPERTY = "com.facebook.sdk.ApplicationName";
    public static final String CLIENT_TOKEN_PROPERTY = "com.facebook.sdk.ClientToken";
    private static Boolean sdkInitialized;

    public static synchronized void sdkInitialize(Context applicationContext, int callbackRequestCodeOffset) {
        if (sdkInitialized.booleanValue() && callbackRequestCodeOffset != FacebookSdk.callbackRequestCodeOffset) {
            throw new FacebookException(CALLBACK_OFFSET_CHANGED_AFTER_INIT);
        }
        if (callbackRequestCodeOffset < 0) {
            throw new FacebookException(CALLBACK_OFFSET_NEGATIVE);
        }
        FacebookSdk.callbackRequestCodeOffset = callbackRequestCodeOffset;
        FacebookSdk.sdkInitialize(applicationContext);
    }

    public static synchronized void sdkInitialize(Context applicationContext) {
        if (sdkInitialized.booleanValue()) {
            return;
        }
        FacebookSdk.applicationContext = applicationContext.getApplicationContext();
        FacebookSdk.loadDefaultsFromMetadata(FacebookSdk.applicationContext);
        Utility.loadAppSettingsAsync(FacebookSdk.applicationContext, applicationId);
        NativeProtocol.updateAllAvailableProtocolVersionsAsync();
        cacheDir = FacebookSdk.applicationContext.getCacheDir();
        FutureTask<Void> accessTokenLoadFutureTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AccessTokenManager.getInstance().loadCurrentAccessToken();
                ProfileManager.getInstance().loadCurrentProfile();
                if (AccessToken.getCurrentAccessToken() != null && Profile.getCurrentProfile() == null) {
                    Profile.fetchProfileForCurrentAccessToken();
                }
                return null;
            }
        });
        FacebookSdk.getExecutor().execute(accessTokenLoadFutureTask);
        sdkInitialized = true;
    }

    public static synchronized boolean isInitialized() {
        return sdkInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(behavior);
            FacebookSdk.updateGraphDebugBehavior();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingBehaviorEnabled(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return FacebookSdk.isDebugEnabled() && loggingBehaviors.contains((Object)behavior);
        }
    }

    public static boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static void setIsDebugEnabled(boolean enabled) {
        isDebugEnabled = enabled;
    }

    public static boolean isLegacyTokenUpgradeSupported() {
        return isLegacyTokenUpgradeSupported;
    }

    private static void updateGraphDebugBehavior() {
        if (loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_INFO) && !loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_WARNING)) {
            loggingBehaviors.add(LoggingBehavior.GRAPH_API_DEBUG_WARNING);
        }
    }

    public static void setLegacyTokenUpgradeSupported(boolean supported) {
        isLegacyTokenUpgradeSupported = supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                Executor executor = FacebookSdk.getAsyncTaskExecutor();
                if (executor == null) {
                    executor = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, DEFAULT_WORK_QUEUE, DEFAULT_THREAD_FACTORY);
                }
                FacebookSdk.executor = executor;
            }
        }
        return executor;
    }

    public static String getFacebookDomain() {
        return facebookDomain;
    }

    public static Context getApplicationContext() {
        return applicationContext;
    }

    private static Executor getAsyncTaskExecutor() {
        Field executorField = null;
        try {
            executorField = AsyncTask.class.getField("THREAD_POOL_EXECUTOR");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        Object executorObject = null;
        try {
            executorObject = executorField.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (executorObject == null) {
            return null;
        }
        if (!(executorObject instanceof Executor)) {
            return null;
        }
        return (Executor)executorObject;
    }

    public static boolean getLimitEventAndDataUsage(Context context) {
        SharedPreferences preferences = context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        return preferences.getBoolean("limitEventUsage", false);
    }

    @TargetApi(value=9)
    public static void setLimitEventAndDataUsage(Context context, boolean limitEventUsage) {
        context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0).edit().putBoolean("limitEventUsage", limitEventUsage).apply();
    }

    public static long getOnProgressThreshold() {
        return onProgressThreshold.get();
    }

    public static void setOnProgressThreshold(long threshold) {
        onProgressThreshold.set(threshold);
    }

    static void loadDefaultsFromMetadata(Context context) {
        if (context == null) {
            return;
        }
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            return;
        }
        if (applicationId == null) {
            Object appId = ai.metaData.get(APPLICATION_ID_PROPERTY);
            if (appId instanceof String) {
                applicationId = (String)appId;
            } else if (appId instanceof Integer) {
                applicationId = appId.toString();
            }
        }
        if (applicationName == null) {
            applicationName = ai.metaData.getString(APPLICATION_NAME_PROPERTY);
        }
        if (appClientToken == null) {
            appClientToken = ai.metaData.getString(CLIENT_TOKEN_PROPERTY);
        }
    }

    public static String getApplicationSignature(Context context) {
        MessageDigest md;
        PackageInfo pInfo;
        if (context == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        String packageName = context.getPackageName();
        try {
            pInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        Signature[] signatures = pInfo.signatures;
        if (signatures == null || signatures.length == 0) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(pInfo.signatures[0].toByteArray());
        return Base64.encodeToString((byte[])md.digest(), (int)9);
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static void setApplicationId(String applicationId) {
        FacebookSdk.applicationId = applicationId;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setApplicationName(String applicationName) {
        FacebookSdk.applicationName = applicationName;
    }

    public static String getClientToken() {
        return appClientToken;
    }

    public static void setClientToken(String clientToken) {
        appClientToken = clientToken;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public static void setCacheDir(File cacheDir) {
        FacebookSdk.cacheDir = cacheDir;
    }

    public static int getCallbackRequestCodeOffset() {
        return callbackRequestCodeOffset;
    }

    public static boolean isFacebookRequestCode(int requestCode) {
        return requestCode >= callbackRequestCodeOffset && requestCode < callbackRequestCodeOffset + 100;
    }

    static {
        facebookDomain = FACEBOOK_COM;
        onProgressThreshold = new AtomicLong(65536L);
        isDebugEnabled = false;
        isLegacyTokenUpgradeSupported = false;
        callbackRequestCodeOffset = 64206;
        LOCK = new Object();
        DEFAULT_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
        DEFAULT_THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "FacebookSdk #" + this.counter.incrementAndGet());
            }
        };
        sdkInitialized = false;
    }
}

