/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.tauth.Tencent;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class UMTencentSSOHandler
extends UMSSOHandler {
    private static final String TAG = "UMTencentSSOHandler";
    protected ProgressDialog mProgressDialog = null;
    protected static Map<String, String> mImageCache = new HashMap<String, String>();
    protected String mImageUrl = null;
    public PlatformConfig.QQZone config = null;
    protected UMAuthListener mAuthListener;
    protected UMAuthListener mAuthListenerBackup;
    protected Tencent mTencent;
    protected UMShareListener mShareListener;
    private static final String PUBLIC_ACCOUNT = "100424468";

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.config = (PlatformConfig.QQZone)p;
        Log.d((String)"appid", (String)("appid qq:" + this.config.appId));
        this.mTencent = Tencent.createInstance((String)this.config.appId, (Context)context);
        if (this.mTencent == null) {
            Log.e((String)TAG, (String)"Tencent\u53d8\u91cf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f60\u7684app id\u8ddfAndroidManifest.xml\u6587\u4ef6\u4e2dAuthActivity\u7684scheme\u662f\u5426\u586b\u5199\u6b63\u786e");
        }
    }

    protected Bundle parseOauthData(Object response) {
        Bundle bundle = new Bundle();
        if (response == null) {
            return bundle;
        }
        String jsonStr = response.toString().trim();
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return bundle;
        }
        JSONObject json = null;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (json == null) {
            return bundle;
        }
        bundle.putString("auth_time", json.optString("auth_time", ""));
        bundle.putString("pay_token", json.optString("pay_token", ""));
        bundle.putString("pf", json.optString("pf", ""));
        bundle.putString("ret", String.valueOf(json.optInt("ret", -1)));
        bundle.putString("sendinstall", json.optString("sendinstall", ""));
        bundle.putString("page_type", json.optString("page_type", ""));
        bundle.putString("appid", json.optString("appid", ""));
        bundle.putString("openid", json.optString("openid", ""));
        bundle.putString("uid", json.optString("openid", ""));
        String expiresStr = json.optString("expires_in", "");
        bundle.putString("expires_in", expiresStr);
        bundle.putString("pfkey", json.optString("pfkey", ""));
        bundle.putString("access_token", json.optString("access_token", ""));
        return bundle;
    }

    protected String getAppName() {
        CharSequence sequence;
        if (!TextUtils.isEmpty((CharSequence)Config.QQAPPNAME)) {
            return Config.QQAPPNAME;
        }
        String appName = "";
        if (this.getContext() != null && !TextUtils.isEmpty((CharSequence)(sequence = this.getContext().getApplicationInfo().loadLabel(this.getContext().getPackageManager())))) {
            appName = sequence.toString();
        }
        return appName;
    }

    public void getBitmapUrl(UMediaObject uMediaObjects, String usid, ObtainImageUrlListener listener) {
        String imageLocalPath;
        String imageCachePath;
        UMediaObject media = uMediaObjects;
        long startTime = System.currentTimeMillis();
        UMImage image = null;
        if (media instanceof UMImage) {
            image = (UMImage)media;
        }
        if (image != null && !TextUtils.isEmpty((CharSequence)(imageCachePath = mImageCache.get(imageLocalPath = image.asFileImage().toString())))) {
            this.mImageUrl = imageCachePath;
            Log.i((String)TAG, (String)("obtain image url form cache..." + this.mImageUrl));
        }
        Log.i((String)TAG, (String)"doInBackground end...");
        listener.onComplete(this.mImageUrl);
    }

    private void setImageUrl(String localPath, String urlPath) {
        if (!TextUtils.isEmpty((CharSequence)urlPath)) {
            mImageCache.put(localPath, urlPath);
            this.mImageUrl = urlPath;
        }
    }

    protected boolean validTencent() {
        return this.mTencent != null && this.mTencent.getAppId().equals(this.config.appId);
    }

    public static interface ObtainImageUrlListener {
        public void onComplete(String var1);
    }

    protected static interface ObtainAppIdListener {
        public void onComplete();
    }
}

