/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.connect.UserInfo;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QQShareContent;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UMQQSsoHandler
extends UMTencentSSOHandler {
    private static final String TAG = "UMQQSsoHandler";
    private IUiListener mShareListener;
    private QQShareContent msharecontent;
    private Bundle mParams;
    private QQPreferences qqPreferences;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        if (context != null) {
            this.qqPreferences = new QQPreferences(this.getContext(), SHARE_MEDIA.QQ.toString());
        }
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        this.mParams = null;
        this.mShareListener = this.getSharelistener(listener);
        if (this.mShareListener == null) {
            Log.d((String)"listen", (String)"listener is null");
        }
        if (!this.isInstall()) {
            listener.onError(SHARE_MEDIA.QQ, new Throwable("not install"));
        }
        this.msharecontent = new QQShareContent(content);
        this.shareToQQ();
        return false;
    }

    private IUiListener getSharelistener(final UMShareListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    // empty if block
                }
                listener.onError(SHARE_MEDIA.QQ, null);
            }

            public void onCancel() {
                listener.onCancel(SHARE_MEDIA.QQ);
            }

            public void onComplete(Object response) {
                listener.onResult(SHARE_MEDIA.QQ);
            }
        };
    }

    public boolean isAuthorize() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.isAuthValid();
        }
        return false;
    }

    public void authorize(UMAuthListener listener) {
        this.mAuthListener = listener;
        this.loginDeal();
    }

    public void setAuthListener(UMAuthListener listener) {
        this.mAuthListenerBackup = listener;
    }

    private IUiListener getAuthlistener(final UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    Log.d((String)UMQQSsoHandler.TAG, (String)("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
                }
                listener.onError(SHARE_MEDIA.QQ, 0, new Throwable("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                if (listener != null) {
                    listener.onCancel(SHARE_MEDIA.QQ, 0);
                }
            }

            public void onComplete(Object response) {
                int status;
                SocializeUtils.safeCloseDialog((Dialog)UMQQSsoHandler.this.mProgressDialog);
                Bundle values = UMQQSsoHandler.this.parseOauthData(response);
                if (UMQQSsoHandler.this.qqPreferences == null && UMQQSsoHandler.this.getContext() != null) {
                    UMQQSsoHandler.this.qqPreferences = new QQPreferences(UMQQSsoHandler.this.getContext(), SHARE_MEDIA.QQ.toString());
                }
                if (UMQQSsoHandler.this.qqPreferences != null) {
                    UMQQSsoHandler.this.qqPreferences.setAuthData(values).commit();
                }
                UMQQSsoHandler.this.initOpenidAndToken((JSONObject)response);
                if (listener != null) {
                    listener.onComplete(SHARE_MEDIA.QQ, 0, SocializeUtils.bundleTomap((Bundle)values));
                }
                UMQQSsoHandler.this.uploadAuthData(values);
                if (values != null && (status = Integer.valueOf(values.getString("ret")).intValue()) == 0) {
                    return;
                }
            }
        };
    }

    public boolean isInstall() {
        return this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public String getSDKVersion() {
        return "3.1.0";
    }

    public boolean isSupport() {
        return this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public void deleteAuth(UMAuthListener listener) {
        this.mTencent.logout(this.getContext());
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
        listener.onComplete(SHARE_MEDIA.QQ, 1, null);
    }

    public boolean isSupportAuth() {
        return true;
    }

    private void loginDeal() {
        Log.i((String)TAG, (String)"QQ oauth login...");
        if (this.isInstall()) {
            Log.d((String)"qq", (String)"installed qq");
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                this.mTencent.login((Activity)this.mWeakAct.get(), "all", this.getAuthlistener(this.mAuthListener));
            }
        } else if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mTencent.loginServerSide((Activity)this.mWeakAct.get(), "all", this.getAuthlistener(this.mAuthListener));
        }
    }

    public void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (UMQQSsoHandler.this.getContext() != null && bundle != null && UMQQSsoHandler.this.config != null) {
                    PlatformTokenUploadReq req = new PlatformTokenUploadReq(UMQQSsoHandler.this.getContext());
                    req.addStringParams("to", "qq");
                    req.addStringParams("usid", bundle.getString("uid"));
                    req.addStringParams("access_token", bundle.getString("access_token"));
                    req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                    req.addStringParams("expires_in", bundle.getString("expires_in"));
                    PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                    Log.e((String)("upload token resp = " + resp));
                }
            }
        }).start();
    }

    public void shareToQQ() {
        if (this.validTencent()) {
            this.defaultShareToQQ(this.msharecontent);
        } else {
            Log.d((String)TAG, (String)"QQ\u5e73\u53f0\u8fd8\u6ca1\u6709\u6388\u6743");
            this.authorize(null);
        }
    }

    private void defaultShareToQQ(QQShareContent shareContent) {
        this.mParams = this.msharecontent.buildParams();
        this.mParams.putString("appName", this.getAppName());
        if (this.mParams != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (UMQQSsoHandler.this.mWeakAct.get() != null && !((Activity)UMQQSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        UMQQSsoHandler.this.mTencent.shareToQQ((Activity)UMQQSsoHandler.this.mWeakAct.get(), UMQQSsoHandler.this.mParams, UMQQSsoHandler.this.mShareListener);
                    }
                }
            });
        }
    }

    public int getRequestCode() {
        return 10103;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10103) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.mShareListener);
        }
        if (requestCode == 11101) {
            if (this.mAuthListener == null && this.mAuthListenerBackup != null && this.mTencent != null) {
                Tencent.handleResultData((Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListenerBackup));
            }
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        if (this.isAuthorize()) {
            try {
                String token = this.qqPreferences.getmAccessToken();
                UMQQSsoHandler uMQQSsoHandler = this;
                String expires = uMQQSsoHandler.qqPreferences.getExpiresIn();
                String openId = this.qqPreferences.getmUID();
                if (this.qqPreferences != null) {
                    token = this.qqPreferences.getmAccessToken();
                    UMQQSsoHandler uMQQSsoHandler2 = this;
                    expires = uMQQSsoHandler2.qqPreferences.getExpiresIn();
                    openId = this.qqPreferences.getmUID();
                }
                if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                    this.mTencent.setAccessToken(token, expires);
                    this.mTencent.setOpenId(openId);
                }
            }
            catch (Exception token) {}
        } else {
            this.authorize(new UMAuthListener(){

                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                    UMQQSsoHandler.this.getPlatformInfo(listener);
                }

                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                    listener.onError(SHARE_MEDIA.QQ, 2, t);
                }

                public void onCancel(SHARE_MEDIA platform, int action) {
                    listener.onCancel(SHARE_MEDIA.QQ, 2);
                }
            });
            return;
        }
        UserInfo userInfo = new UserInfo(this.getContext(), this.mTencent.getQQToken());
        userInfo.getUserInfo(new IUiListener(){

            public void onCancel() {
            }

            public void onComplete(Object arg) {
                try {
                    JSONObject jsonObject = new JSONObject(arg.toString());
                    HashMap<String, String> infos = new HashMap<String, String>();
                    infos.put("screen_name", jsonObject.optString("nickname"));
                    infos.put("gender", jsonObject.optString("gender"));
                    infos.put("profile_image_url", jsonObject.optString("figureurl_qq_2"));
                    infos.put("is_yellow_year_vip", jsonObject.optString("is_yellow_year_vip"));
                    infos.put("yellow_vip_level", jsonObject.optString("yellow_vip_level"));
                    infos.put("msg", jsonObject.optString("msg"));
                    infos.put("city", jsonObject.optString("city"));
                    infos.put("vip", jsonObject.optString("vip"));
                    infos.put("level", jsonObject.optString("level"));
                    infos.put("province", jsonObject.optString("province"));
                    infos.put("is_yellow_vip", jsonObject.optString("is_yellow_vip"));
                    if (UMQQSsoHandler.this.qqPreferences != null) {
                        infos.put("openid", UMQQSsoHandler.this.qqPreferences.getuid());
                        infos.put("uid", UMQQSsoHandler.this.qqPreferences.getuid());
                        infos.put("access_token", UMQQSsoHandler.this.qqPreferences.getmAccessToken());
                        infos.put("expires_in", UMQQSsoHandler.this.qqPreferences.getMtl());
                    }
                    listener.onComplete(SHARE_MEDIA.QQ, 2, infos);
                }
                catch (JSONException e) {
                    listener.onComplete(SHARE_MEDIA.QQ, 2, null);
                }
            }

            public void onError(UiError arg0) {
                listener.onError(SHARE_MEDIA.QQ, 2, new Throwable(arg0.toString()));
            }
        });
    }
}

