/*
 * Decompiled with CFR 0.152.
 */
package jp.line.android.sdk.login;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import jp.line.android.sdk.login.LineLoginFutureListener;
import jp.line.android.sdk.login.LineLoginFutureProgressListener;
import jp.line.android.sdk.model.AccessToken;
import jp.line.android.sdk.model.Otp;
import jp.line.android.sdk.model.RequestToken;

public interface LineLoginFuture {
    public boolean isForceLoginByOtherAccount();

    public boolean isSameRequest(boolean var1, Locale var2);

    public long getCreatedTime();

    public boolean isProcessing();

    public ProgressOfLogin getProgress();

    public Otp getOtp();

    public RequestToken getRequestToken();

    public AccessToken getAccessToken();

    public Throwable getCause();

    public Locale getLocale();

    public void await();

    public boolean await(long var1, TimeUnit var3);

    public boolean addFutureListener(LineLoginFutureListener var1);

    public boolean removeFutureListener(LineLoginFutureListener var1);

    public boolean addProgressListener(LineLoginFutureProgressListener var1);

    public boolean removeProgressListener(LineLoginFutureProgressListener var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProgressOfLogin {
        STARTED(0, 0),
        REQUESTED_OTP(10, 1),
        GOT_OTP(11, 2),
        STARTED_A2A_LOGIN(20, 3),
        STARTED_WEB_LOGIN(21, 3),
        GOT_REQUEST_TOKEN(22, 4),
        REQUESTED_ACCESS_TOKEN(30, 5),
        SUCCESS(100, 100),
        FAILED(101, 100),
        CANCELED(102, 100);

        public final int code;
        public final int flowNumber;

        private ProgressOfLogin(int n3, int n4) {
            this.code = n3;
            this.flowNumber = n4;
        }

        public static ProgressOfLogin findValueByCode(int n2) {
            for (ProgressOfLogin progressOfLogin : ProgressOfLogin.values()) {
                if (progressOfLogin.code != n2) continue;
                return progressOfLogin;
            }
            return STARTED;
        }
    }
}

