/*
 * Decompiled with CFR 0.152.
 */
package jp.line.android.sdk;

import android.content.Context;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jp.line.android.sdk.LineSdkContext;
import jp.line.android.sdk.LineSdkContextInitializer;
import jp.line.android.sdk.Phase;
import jp.line.android.sdk.a.c.b;
import jp.line.android.sdk.api.ApiClient;
import jp.line.android.sdk.login.LineAuthManager;

public final class LineSdkContextManager {
    static CountDownLatch initializeLatch;
    static LineSdkContext lineSdkConfig;

    private LineSdkContextManager() {
    }

    public static final void initialize(Context context) {
        LineSdkContextManager.initialize(context, -1, null, null);
    }

    public static final void initialize(Context context, int n2, Phase phase) {
        LineSdkContextManager.initialize(context, n2, phase, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final void initialize(Context context, int n2, Phase phase, LineSdkContextInitializer lineSdkContextInitializer) {
        boolean bl = false;
        if (lineSdkConfig == null && initializeLatch == null) {
            Class<LineSdkContextManager> clazz = LineSdkContextManager.class;
            // MONITORENTER : jp.line.android.sdk.LineSdkContextManager.class
            if (lineSdkConfig == null && initializeLatch == null) {
                initializeLatch = new CountDownLatch(1);
                bl = true;
            }
            // MONITOREXIT : clazz
        }
        if (!bl) return;
        Executors.newSingleThreadExecutor().execute(new jp.line.android.sdk.a(lineSdkContextInitializer, context, n2, phase));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static LineSdkContext getSdkContext() {
        CountDownLatch countDownLatch;
        if (lineSdkConfig != null) return lineSdkConfig;
        if (initializeLatch != null) {
            countDownLatch = initializeLatch;
        } else {
            Class<LineSdkContextManager> clazz = LineSdkContextManager.class;
            // MONITORENTER : jp.line.android.sdk.LineSdkContextManager.class
            if (initializeLatch == null) {
                throw new RuntimeException("LineSdkConfig was not initialized.");
            }
            countDownLatch = initializeLatch;
            // MONITOREXIT : clazz
        }
        try {
            countDownLatch.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (lineSdkConfig != null) return lineSdkConfig;
        throw new RuntimeException("LineSdkConfig was not initialized.");
    }

    public static final class a
    implements LineSdkContextInitializer {
        public final LineAuthManager createAuthManager(LineSdkContext lineSdkContext) {
            return new b();
        }

        public final ApiClient createApiClient(LineSdkContext lineSdkContext) {
            return new jp.line.android.sdk.a.a.a();
        }
    }
}

